package yangtz.cs.liu.campus.vo.patrol;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.Date;

@Data
public class SchoolPatrolVo extends OurBaseEntity {

    private static final long serialVersionUID = 1L;

    /** 年级 */
    @Excel(name = "年级" ,readConverterExp = "1=一年级,2=二年级,3=三年级,4=四年级,5=五年级,6=六年级,7=七年级,8=八年级,9=九年级," )
    private Long gradeValue;

    /** 班级 */
    @Excel(name = "班级" ,readConverterExp = "1=一班,2=二班,3=三班,4=四班,5=五班,6=六班,7=七班,8=八班,9=九班," )
    private Long classValue;

    /** 班级id */
    private Long classId;

    /** 描述 */
    @Excel(name = "描述")
    private String remarks;

    /** 得分 */
    @Excel(name = "得分")
    private String score;

    /** 巡检日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "巡检日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date patrolDate;

    /** 检查员 */
    @Excel(name = "检查员")
    private String userName;

    /** 检查员id */
    private Long inspectorId;

}
