package yangtz.cs.liu.campus.vo.exam;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.campus.domain.exam.ExamDetail;
import yangtz.cs.liu.campus.domain.exam.ExamUserScore;
import yangtz.cs.liu.campus.domain.exam.ExamUserScoreDetail;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class ScoreVo  {
    private static final long serialVersionUID = 1L;


    /** 用户选项的集合 */
    @Valid
    @NotNull(message = "考试集合不能为空")
    private List<ExamUserScoreDetail> examUserScoreDetailList;


    /** 分数 */
    @Excel(name = "分数")
    @NotNull(message = "总分不能为空")
    private Integer score;

    /** 问卷Id */
    @NotNull(message = "问卷Id不能为空")
    private Long examId;

    /** 问卷名称 */
    @NotBlank(message = "问卷名称不能为空")
    private String examName;
}
