package yangtz.cs.liu.campus.vo.epidemic;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

@Data
public class EpidemicMainVo extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /** 活动名称 */
    @Excel(name = "活动名称")
    private String epidemicName;

    /** 选择的问卷范围 角色类别 */
    @Excel(name = "选择的问卷范围 角色类别")
    private String optionScope;

    /** 0未开始，1进行中，2已结束 */
    @Excel(name = "0未开始，1进行中，2已结束")
    private String state;

    /** 答题开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "答题开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 答题结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "答题结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 是否 领导考题  是否 */
    @Excel(name = "是否 领导考题  是否")
    private String isLeaderExam;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 部门 */
    @Excel(name = "部门")
    private String deptName;

    /** 查询条件 根据userId 查询其参加的活动 */
    private Long userId;

    /**参与人数**/
    private Long num;
}
