package yangtz.cs.liu.campus.vo.device;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class RecordByIdVo {

    /** id */
    private Long id;
    /** 设备id */
    @NotNull(message ="不为空")
    private Long deviceId;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String deviceName;

    /** 故障描述 */
    @Excel(name = "故障描述")
    private String faultDescription;

    /** 报修类型 */
    @Excel(name = "报修类型")
    private String repairType;

    /** 提报人 */
    @Excel(name = "提报人")
    private String Informant;

    /** 提报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "提报时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date reportingTime;

    /** 维修人 */
    @Excel(name = "维修人")
    private String maintainer;

    /** 维修完成时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "维修完成时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date maintenanceCompletionTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    private String roleKey;
    private String roleName;

}
