package yangtz.cs.liu.campus.service.time;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.Ztree;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.time.SchoolCourseSchedule;
import yangtz.cs.liu.campus.domain.time.SchoolSchedule;
import yangtz.cs.liu.campus.domain.time.SchoolTimeTable;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;
import yangtz.cs.liu.campus.vo.time.ExportScheduleVo;
import yangtz.cs.liu.campus.vo.time.ScheduleVo;
import yangtz.cs.liu.campus.vo.time.SchoolCourseTableVO;
import yangtz.cs.liu.campus.vo.time.TableVO;
import yangtz.cs.liu.wechat.vo.schoolTime.SchoolTimeTableVo;

import java.util.List;

public interface ISchoolTimeTableService extends IService<SchoolTimeTable> {

    /**
     * 查询课程列表
     *
     * @param schoolTimeTable 课程
     * @return 课程集合
     */
    List<SchoolCourseTableVO> selectSchoolTimeTableList(SchoolTimeTable schoolTimeTable);

    /**
     * 课程表
     */
    List<TableVO> selectSchoolSchedule(SchoolTimeTable schoolTimeTable);

    /**
     * 课程表新增或修改
     */
    int addSchoolSchedule(List<TableVO> list,Long classId,Integer termId);

    /**
     * 教师个人课程表
     *
     */
    List<TableVO> getTeacherTable(Long teacherId);

    /**
     * 制作 课程表
     *
     */
    List<SchoolCourseSchedule> getCourseSchedule(SchoolTimeTable schoolTimeTable);

    /**
     * 导入试题数据
     *
     * @param list 数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @return 结果
     */
//    String importExamDetailSchedule(List<SchoolSchedule> list, Boolean isUpdateSupport,
//                                    SchoolTimeTable schoolTimeTable);

    /**
     * 课程表树形结构
     */
    List<Ztree> selectSchoolClassListForTreeNew(SchoolClass schoolClass);

    /**
     *  加载 整个班级列表
     */
    List<SchoolClass> getSchoolClassList(SchoolClass schoolClass);


    /**
     * 微信公众号获取课表
     * @param schoolTimeTableVo
     * @return
     */
    List<SchoolTimeTableVo> getSchoolSchedule(SchoolTimeTableVo schoolTimeTableVo);

    List<SchoolTimeTableVo> getTimeTable(Long teacherId);

    void saveSchedule(List<SchoolSchedule> list);

    SchoolTimeTable setGradeAndTime(Long studentId);

    /**公众号》学生课表*/
    List<TableVO> getStudentTable(Long studentId,Long classId,int termId);

    Boolean exportSchedule(List<ScheduleVo> list, String path) ;

    /**
     * 课程表导出
     */
    List<ExportScheduleVo> exportTable(Long classId, Integer termId);

    /**
     * 导入数据校验
     * @param list
     */
    void checkImport(List<ExportScheduleVo> list);
    /**
     * 导入数据
     * @param list
     * @return
     */
    String importData(List<ExportScheduleVo> list,Long classId, Integer termId);

    Boolean importExcel(SchoolTimeTable schoolTimeTable,MultipartFile  file);


}
