package yangtz.cs.liu.campus.service.teacher;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import com.ruoyi.common.core.domain.entity.SysUser;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherNameListVo;

import java.util.List;

public interface ISchoolTeacherService extends IService<SchoolTeacher> {

    //获取教师列表
    public List<SchoolTeacher> selectSchoolTeacherList(SchoolTeacherVO schoolTeacher);
    public List<SchoolTeacher> teacherList(SchoolTeacherVO schoolTeacher);


    //添加老师信息
    String insertTeacher(SchoolTeacher schoolTeacher);

    /*
     *老获取所有老师的名字
     * */
    List<TeacherNameListVo> selectSchoolTeacherNameList();

    //id获取教师列表
    List<SchoolTeacher> listByIds(List<Long> ids);

    //修改教师信息
    String updateSchoolTeacher(SchoolTeacher schoolTeacher);

    //判断老师信息是否重复
//    SchoolTeacher judgeSchoolTeacher(SchoolTeacherVO schoolTeacher);

    //删除老师信息byIds
    int deleteSchoolTeacherByIds(List<Long> ids);

    //删除老师信息byid
//    int deleteSchoolTeacherById(Long id);

    /*
     * 导入老师信息
     * */
    String importStudent(List<SchoolTeacherVO> dataManagementList, boolean updateSupport, String operName);


    /**
     * 公众号获取老师信息
     *
     * @param studentId
     * @return
     */
    List<SchoolTeacher> getTeacherInfo(Long studentId);

    /**
     * 公众号获取所有老师信息
     *
     * @param teacherName
     * @return
     */
    List<SchoolTeacher> queryList(String teacherName);

    /**
     * 老师导入，数据校验
     *
     * @param list
     */
    void checkImport(List<SchoolTeacher> list);

    /**
     * @author lyric
     * @date 2022/11/1 18:02
     * <p>
     * 老师导入 TODO 修改用户表
     */
    String importData(List<SchoolTeacher> list);

    /**检查设备号是否唯一*/
    void checkDeviceNumUnique(SchoolTeacherVO schoolTeacher);

    /**检查教师编号是否唯一*/
    void checkTeacherCodeUnique(SchoolTeacherVO schoolTeacher);

    /**检查身份证号是否唯一*/
    void checkIdCardUnique(SchoolTeacherVO schoolTeacher);

    /**检查手机号是否唯一*/
    void checkTeacherTelUnique(SchoolTeacherVO schoolTeacher);

    /**检查邮箱账号是否唯一*/
    void checkEmailUnique(SchoolTeacherVO schoolTeacher);
    /**检查密码是否符合条件(密码必须包含大小写字母，数字)*/
    void checkPasswordUnique(SchoolTeacherVO schoolTeacherVO);

    /**
     * 新增教师
     */
    int insert(SchoolTeacherVO schoolTeacherVO);

    /**
     * 修改教师
     */
    int updateTeacher(SchoolTeacherVO schoolTeacherVO);

    /**
     * 个人信息
     */
    int editProfile(SchoolTeacherVO schoolTeacherVO);

    /**
     *
     * @author lyric
     * @date 2022/11/19 13:58
     * 删除教师
     */
    int deleteTeacher(List<Long> ids);

    /**
     *
     * @author lyric
     * @date 2022/11/19 14:11
     * 教师信息回显
     */
    SchoolTeacherVO queryOne(Long id);

    /**个人工作->基本信息*/
    SchoolTeacher getProfile();

    //查询全部教职工
    List<SchoolTeacher> getAllTeachers(SchoolTeacher teacher);

    /**
     * 获取所在处室处室主任,校领导
     */
    List<SchoolTeacher> getSectionLeader(Long deptId, String role,SchoolTeacherVO teacher);

    List<SchoolTeacherVO> getTeachers(Long classId);

    public boolean updatePic(Long userId, String avatar);

    /**
     *
     * 根据userId 查询 openId
     */
    String getOpenIdByUserId(Long userId);


}
