package yangtz.cs.liu.campus.service.teacher;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.office.SchoolOfficePurchase;
import yangtz.cs.liu.campus.domain.student.SchoolStudentLeave;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherOvertime;
import yangtz.cs.liu.campus.vo.office.OfficeTodoListVO;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherOvertimeVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherLeaveVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherOvertimeVO;

import java.util.List;
import java.util.Map;

public interface ISchoolTeacherOvertimeService extends IService<SchoolTeacherOvertime> {

    /**
     * 查询老师加班列表
     */
    List<SchoolTeacherOvertimeVO> selectSchoolTeacherOvertimeList(String submitState, SchoolTeacherOvertimeVO schoolTeacherOvertimeVO);

    /*
     * 删除老师加班信息根据老师id
     * */
    int removeSchoolTeacherOvertimeByIds(List<Long> ids);

    /*
     * 删除老师加班信息根据id
     * */
    int removeSchoolTeacherOvertimeById(List<Long> ids);

    /**
     * 流程定义
     *
     * @param schoolTeacherOvertime
     * @param username
     * @param key
     * @param variables
     */
    int submitApply(SchoolTeacherOvertime schoolTeacherOvertime, String username, String key, Map<String, Object> variables);

    /**
     * 待办列表
     *
     * @param entity
     * @param userId
     * @return
     */
    List<TeacherOvertimeVO> findTodoTasks(String key, SchoolTeacherOvertime entity, String userId);

    /**
     * 已办列表
     *
     * @param key
     * @param entity
     * @param userId
     * @return
     */
    List<TeacherOvertimeVO> findDoneTasks(String key, SchoolTeacherOvertime entity, String userId);

    List<TeacherOvertimeVO> subList(List<TeacherOvertimeVO> list, int page, int rows);

    /**
     * @param taskId
     * @param schoolTeacherOvertime 销假
     * @author lyric
     * @date 2022/10/28 10:44
     */
    void cancelLeave(String taskId, SchoolTeacherOvertime schoolTeacherOvertime);


}
