package yangtz.cs.liu.campus.service.student;

import com.baomidou.mybatisplus.extension.service.IService;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.vo.student.SchoolStudentNameVO;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;
import yangtz.cs.liu.wechat.vo.userInfo.UserInfoVo;

import java.util.List;

public interface ISchoolStudentService extends IService<SchoolStudent> {

    List<SchoolStudentVO> queryList(SchoolStudentVO schoolStudent);

    //按条件导出
    List<SchoolStudentVO> exportQueryList(SchoolStudentVO schoolStudent);

    //按选中行导出
    List<SchoolStudentVO> exportSelect(List<Long> ids);

    /**
     * 获取学生姓名和id列表
     *
     * @param schoolStudent
     * @return
     */
    List<SchoolStudentNameVO> queryName(SchoolStudent schoolStudent);

    int deleteByIds(List<Long> ids);

    /*
    * 导入学生
    * */
    String importStudent(List<SchoolStudentVO> dataManagementList,boolean updateSupport, String operName);

    /*
    * 修改学生
    * */
    String updateStudent(SchoolStudent schoolStudent);
    /*
    * 新增学生
    * */
    String addStudent(SchoolStudent schoolStudent);

    SchoolStudentVO getInfo(Long id);

    /**
     * 通过身份证号获取信息
     * @param idCard
     * @return
     */
    SchoolStudentVO getInfoByidCard(String idCard);

    /**
     * 公众号老师查看具体带的学生
     * @param teacherId
     * @return
     */
    List<SchoolStudent> getMemberByTeacher(Long teacherId);

    /**
     * 家长查看班级其他同学
     * @param studentId
     * @return
     */
    List<SchoolStudent> getMemberByParent(Long studentId);


    /**
     * 老师根据班级id查看学生
     * @param classId
     * @return
     */
    List<SchoolStudent> getMemberByClassId(Long classId,String studentName);

    /**
     * 公众号：教职工通过学生id查询学生基本信息
     *
     * @param studentId
     * @return
     */
    List<UserInfoVo> getStudentInfo(Long studentId);

    /**
     *
     * @author lyric
     * @date 2022/10/30 14:02
     * @param list
     * 校验学生导入
     */
//    void checkImport(List<SchoolStudentVO> list);


    /**
     * 导入数据校验
     * @param list
     */
    void checkImport(List<SchoolStudentVO> list);

    /**
     * 导入数据
     * @param list
     * @return
     */
    String importData(List<SchoolStudentVO> list);

    List<SchoolStudentVO> getList(SchoolStudentVO schoolStudent);

    /**获取级部学生*/
    List<SchoolStudentVO> getGradeStudent(List<Long> classIds,SchoolStudentVO studentVO);

    /**
     * 家长端修改头像（学生头像）
     * */
    public boolean updateStudentAvatar(Long id, String avatar);

    /*
    * 批量导入学生照片
    * */
    String importStudentPicture(MultipartFile file);
}
