package yangtz.cs.liu.campus.service.student;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.domain.student.SchoolStudentParent;
import yangtz.cs.liu.campus.vo.student.SchoolStudentParentVO;
import yangtz.cs.liu.wechat.vo.userInfo.UserInfoVo;

import java.util.List;

public interface ISchoolStudentParentService extends IService<SchoolStudentParent> {

    /**
     * @author lyric
     * @date 2022/11/19 19:40
     * 学生家长列表
     */
    List<SchoolStudentParent> queryList(SchoolStudentParent schoolStudentParent);

    /**
     * 公众号，获取用户信息
     *
     * @param studentId
     * @return
     */
    List<UserInfoVo> getUserInfo(Long studentId);


    /**
     * 公众号添加监护人
     *
     * @param schoolStudentParent
     * @return
     */
    int additional(SchoolStudentParent schoolStudentParent);

    /**
     * 公众号切换子女准备
     *
     * @param phone
     * @return
     */
    List<SchoolStudent> changePrepare(String phone);

    /**
     *
     * @author lyric
     * @date 2022/11/19 19:47
     * 新增学生家长
     */
    int saveStudentParent(SchoolStudentParent schoolStudentParent);

    int updateStudentParent(SchoolStudentParent schoolStudentParent);

    /**
     * @author lyric
     * @date 2022/11/19 19:43
     * 删除学生家长
     */
    int removeParent(List<Long> ids);

    /**
     *
     * @author lyric
     * @date 2022/11/19 20:33
     * @param studentId
     * @param schoolStudentParent
     * @return int
     * 新增学生家长
     */
    int addParent(Long studentId, SchoolStudentParent schoolStudentParent);

    /**
     *
     * @author lyric
     * @date 2022/11/19 20:36
     * @param studentId
     * @param schoolStudentParent
     * @return int
     * 修改学生家长
     */
    int updateParent(Long studentId, SchoolStudentParent schoolStudentParent);

    /**
     * 查询级部工作-家长信息
     * */
    List<SchoolStudentParentVO> getAllParent( List<Long> idList,SchoolStudentParentVO schoolStudentParentVO);

    //教务管理->全部家长信息查询
    List<SchoolStudentParentVO> selectAllParent(SchoolStudentParentVO schoolStudentParentVO);

    //教师工作，级部工作->家长信息查询
    List<SchoolStudentParentVO> selectTeacherParent(List<Long> classIds,SchoolStudentParentVO schoolStudentParentVO);

    /**
     * 级部过滤拿到年级值
     * @return
     */
    Integer gradeValue();

    /**
     * 根据id 查询 openId
     */
    String getOpenIdById(Long id);
}
