package yangtz.cs.liu.campus.service.schoolEquipment;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.entity.SysUser;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolEquipmentLedger;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolEquipmentLedgerVo;

import java.util.List;
import java.util.Map;

public interface IEquipmentLedgerService extends IService<SchoolEquipmentLedger> {

    /**
     * 查看设备台账列表
     * @param schoolEquipmentLedgerVo
     * @return
     */
    List<SchoolEquipmentLedger> selectSchoolEquipmentLedgerList(SchoolEquipmentLedgerVo schoolEquipmentLedgerVo);

    /**
     * 查看设备台账详细信息
     * @param id
     * @return
     */
    SchoolEquipmentLedger selectSchoolEquipmentLedgerById(Long id);

    /**
     * 新增设备台账信息
     * @param schoolEquipmentLedger
     * @return
     */
    int insertSchoolEquipmentLedger(SchoolEquipmentLedger schoolEquipmentLedger);

    /**
     * 修改设备台账信息
     * @param schoolEquipmentLedger
     * @return
     */
    int updateSchoolEquipmentLedger(SchoolEquipmentLedger schoolEquipmentLedger);

    /**
     * 批量出库设备台账信息
     * @param ids
     * @return
     */
    int outSchoolEquipmentLedger(Long[] ids);

    /**
     * 生成自编码
     * @return
     */
    String getCode(String code);

    /**
     * 导入设备台账
     * @param list
     * @return
     */
    String importExamDetail(List<SchoolEquipmentLedger> list);

    /**
     * 校验
     * @param list
     */
    void checkImport(List<SchoolEquipmentLedger> list);

    /**
     * 获取用户
     * @return
     */
    List<Map<String,String>> getUser(SysUser sysUser);

}
