package yangtz.cs.liu.campus.service.schoolDuty;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolDuty.SchoolDuty;
import yangtz.cs.liu.campus.vo.schoolbudget.SchoolBudgetVo;


/**
 * 值班管理Service接口
 *
 */
public interface ISchoolDutyService extends IService<SchoolDuty>
{
    /**
     * 查询值班管理列表
     *
     * @param schoolDuty 值班管理
     * @return 值班管理集合
     */
    public List<SchoolDuty> selectSchoolDutyList(SchoolDuty schoolDuty);
    /**
     * 查询值班管理列表-节日
     *
     * @param schoolDuty 值班管理
     * @return 值班管理集合
     */
    public List<SchoolDuty> queryList(SchoolDuty schoolDuty);

    /**
     * 修改值班管理
     *
     * @param schoolDuty 值班管理
     * @return 结果
     */
    public int updateSchoolDuty(SchoolDuty schoolDuty);

    /**
     * 判断是否存在
     * @param schoolDuty
     * @return
     */
    Boolean checkIsExist(SchoolDuty schoolDuty);

    void importSchoolBudgetVoList(List<SchoolDuty> list);
}
