package yangtz.cs.liu.campus.service.schoolDcwj;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjAn;

import java.util.List;

/**
 * 回答结果Service接口
 * 
 * @author wengxiulin
 * @date 2023-03-01
 */
public interface ISchoolDcwjAnService extends IService<SchoolDcwjAn>
{
    /**
     * 查询回答结果
     * 
     * @param id 回答结果主键
     * @return 回答结果
     */
    public SchoolDcwjAn selectSchoolDcwjAnById(Long id);

    /**
     * 查询回答结果列表
     * 
     * @param schoolDcwjAn 回答结果
     * @return 回答结果集合
     */
    public List<SchoolDcwjAn> selectSchoolDcwjAnList(SchoolDcwjAn schoolDcwjAn);

    /**
     * 新增回答结果
     * 
     * @param schoolDcwjAn 回答结果
     * @return 结果
     */
    public int insertSchoolDcwjAn(SchoolDcwjAn schoolDcwjAn);

    /**
     * 修改回答结果
     * 
     * @param schoolDcwjAn 回答结果
     * @return 结果
     */
    public int updateSchoolDcwjAn(SchoolDcwjAn schoolDcwjAn);

    /**
     * 批量删除回答结果
     * 
     * @param ids 需要删除的回答结果主键集合
     * @return 结果
     */
    public int deleteSchoolDcwjAnByIds(Long[] ids);

    /**
     * 删除回答结果信息
     * 
     * @param id 回答结果主键
     * @return 结果
     */
    public int deleteSchoolDcwjAnById(Long id);
}
