package yangtz.cs.liu.campus.service.schoolClass;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassMentor;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGradeMentor;
import yangtz.cs.liu.campus.vo.schoolClass.ClassBatchVo;
import yangtz.cs.liu.campus.vo.schoolClass.ClassTreeSelect;
import yangtz.cs.liu.campus.vo.schoolClass.SchoolClassMentorVo;
import yangtz.cs.liu.campus.vo.schoolgrade.GradeTreeSelect;
import yangtz.cs.liu.campus.vo.schoolgrade.SchoolGradeMentorVo;
import yangtz.cs.liu.wechat.vo.schoolClass.SchoolClassVo;
import yangtz.cs.liu.wechat.vo.schoolGrade.SchoolGradeVo;

import java.util.List;

public interface ISchoolClassService extends IService<SchoolClass> {

    List<SchoolClass> selectSchoolClassList(SchoolClass schoolClass);

    public List<SchoolClass> selectClassForSelecter(SchoolClass schoolClass);

    public List<SchoolClass> selectClassForSelecter(Long id);

    public SchoolClass selectSchoolClassById(Long id);

    /**
     * 微信公众号（家长查看班级）
     *
     * @param
     * @return
     */
    SchoolClass getUserClassByParent(Long studentId);

    /**
     * 微信公众号（老师查看班级）
     *
     * @param teacherId
     * @return
     */
    List<SchoolClassVo> getUserClassByTeacher(Long teacherId);
    List<SchoolClassVo> getTeacherClass(Long teacherId);


    /**
     * 校验
     * @param list
     */
    void checkImport(List<SchoolClass> list);

    String importExamDetail(List<SchoolClass> list);

    /**
     *
     * @author lyric
     * @date 2022/11/4 14:45
     * @param schoolClassList
     * @return List<GradeTreeSelect>
     * 构建下拉树
     */
    List<ClassTreeSelect> buildClassTreeList(List<SchoolClass> schoolClassList);

    /**
     * 查询班级老师信息（pc端）
     * @return
     */
    List<SchoolClassMentorVo> getTeacherList(SchoolClassMentor schoolClassMentor);

    /**
     * 班级下拉列表，级部(班级查看)
     * @return
     */
    List<SchoolClass> getClassTressList(List<Long> gradeIds,SchoolClass schoolClass);

    /**
     * 班级列表，级部
     * @return
     */
    List<SchoolClass> getClassList(List<Long> gradeIds,SchoolClass schoolClass);

    /**获取当前学年教师所在班级列表*/
    List<Long> getTeacherClasses(Long userId);

    /**批量新增班级*/
    int batchAdd(ClassBatchVo vo);
}
