package yangtz.cs.liu.campus.service.schoolAtt;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolAtt.SchoolAtt;
import yangtz.cs.liu.campus.vo.schoolAtt.SchoolAttVO;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;

import java.util.Date;
import java.util.List;

public interface ISchoolAttService extends IService<SchoolAtt> {
    //查询打卡记录列表
    public List<SchoolAttVO> queryList(SchoolAtt schoolAtt);

    public List<SchoolAttVO> queryGradeList(List<Long> gradeIds,SchoolAtt schoolAtt);

    //打卡导出
    public List<SchoolAttVO> export(SchoolAtt schoolAtt);

    //级部打卡导出
    public List<SchoolAttVO> exportGrade(List<Long> gradeIds,SchoolAtt schoolAtt);

    /**
     * 导入数据校验
     * @param list
     */
    void checkImport(List<SchoolAttVO> list);

    /**
     * 处理数据，格式化数据
     * */
    List<SchoolAtt> dealData(List<SchoolAttVO> list);

    /**
     * 导入数据
     * @param list
     * @return
     */
    String importData(List<SchoolAtt> list);

    List<SchoolAtt> getDetailsList(Long userId, String date);
    /**
     * 个人工作-编辑备注
     * */
    int editRemark(SchoolAttVO vo);
}
