package yangtz.cs.liu.campus.service.office;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.office.SchoolOfficePurchase;
import yangtz.cs.liu.campus.domain.vehicle.SchoolVehicleApplication;
import yangtz.cs.liu.campus.vo.office.OfficeTodoListVO;
import yangtz.cs.liu.campus.vo.vehicle.VehicleApplicationVO;

import java.util.List;
import java.util.Map;

/**
 * 办公申购Service接口
 *
 * @author xu
 * @date 2022-09-27
 */
public interface ISchoolOfficePurchaseService extends IService<SchoolOfficePurchase>
{
    /**
     * 查询办公申购列表
     *
     * @param schoolOfficePurchase 办公申购
     * @return 办公申购集合
     */
    public List<OfficeTodoListVO> queryList(String submitState,SchoolOfficePurchase schoolOfficePurchase);

    public OfficeTodoListVO getInfo(Long id);

    /**
     * 流程定义
     * @param schoolOfficePurchase
     * @param username
     * @param key
     * @param variables
     */
    int submitApply(SchoolOfficePurchase schoolOfficePurchase, String username, String key, Map<String, Object> variables);

    /**
     * 流程删除
     * @param ids
     * @return
     */
    int deleteOfficePurchaseByIds(List<Long> ids);

    /**
     * 组待办列表
     *
     * @param entity
     * @param userId
     * @return
     */
    List<OfficeTodoListVO> findTodoTasks(String key, SchoolOfficePurchase entity, String userId);

    /**
     * 已办列表
     * @param key
     * @param entity
     * @param userId
     * @return
     */
    List<OfficeTodoListVO> findDoneTasks(String key, SchoolOfficePurchase entity, String userId);

    /**
     * 我的待办列表
     *
     * @param entity
     * @param userId
     * @return
     */
    List<OfficeTodoListVO> findMyTodoTasks(String key, SchoolOfficePurchase entity, String userId);

    /**
     * 查询小程序办公申购列表
     *
     * @param schoolOfficePurchase 办公申购
     * @return 办公申购集合
     */
    public List<OfficeTodoListVO> queryMyList(String submitState,SchoolOfficePurchase schoolOfficePurchase);


}
