package yangtz.cs.liu.campus.service.impl.time;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.core.utils.HolidayDateUtil;
import com.ruoyi.common.core.domain.Ztree;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.course.SchoolCourse;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassMentor;
import yangtz.cs.liu.campus.domain.schoolCurriculum.SchoolCurriculum;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.domain.student.SchoolStudentClassRelation;
import yangtz.cs.liu.campus.domain.time.*;
import yangtz.cs.liu.campus.mapper.course.SchoolCourseMapper;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMapper;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMentorMapper;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentMapper;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentParentMapper;
import yangtz.cs.liu.campus.mapper.time.SchoolTimeDetailMapper;
import yangtz.cs.liu.campus.mapper.time.SchoolTimeMapper;
import yangtz.cs.liu.campus.mapper.time.SchoolTimeTableMapper;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.service.schoolCurriculum.ISchoolCurriculumService;
import yangtz.cs.liu.campus.service.time.ISchoolTimeTableService;
import yangtz.cs.liu.campus.vo.Course.SchoolCourseVO;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;
import yangtz.cs.liu.campus.vo.time.*;
import yangtz.cs.liu.wechat.vo.schoolTime.SchoolTimeTableVo;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;
import static com.ruoyi.common.utils.StringUtils.isNull;
import static yangtz.cs.liu.campus.constant.GradeConstant.NEWTERM;
import static yangtz.cs.liu.campus.constant.WorkTime.*;


@Service
public class SchoolTimeTableServiceImpl extends ServiceImpl<SchoolTimeTableMapper, SchoolTimeTable> implements ISchoolTimeTableService {

    @Autowired
    private SchoolTimeTableMapper schoolTimeTableMapper;

    @Autowired
    private SchoolClassMapper schoolClassMapper;

    @Autowired
    private ISchoolClassService schoolClassService;

    @Autowired
    private SchoolTimeDetailMapper schoolTimeDetailMapper;

    @Autowired
    private SchoolTimeMapper schoolTimeMapper;

    @Autowired
    private SchoolCourseMapper schoolCourseMapper;

    @Autowired
    private SchoolStudentParentMapper schoolStudentParentMapper;

    @Autowired
    private SchoolStudentMapper schoolStudentMapper;

    @Autowired
    private SchoolClassMentorMapper classMentorMapper;

    @Autowired
    private ISchoolCurriculumService schoolCurriculumService;
    public static final String USE = "1";

    /**
     * 查询课程列表
     *
     * @param schoolTimeTable 课程
     * @return 课程
     */
    @Override
    public List<SchoolCourseTableVO> selectSchoolTimeTableList(SchoolTimeTable schoolTimeTable) {
        return schoolTimeTableMapper.selectSchoolTimeTableList(schoolTimeTable);
    }

    /**
     * 查询 课程表（教务&班主任）
     */
    @Override
    public List<TableVO> selectSchoolSchedule(SchoolTimeTable schoolTimeTable) {
        //return schoolTimeTableMapper.selectSchoolSchedule(schoolTimeTable);
        //参数必有班级id ，学期
        //获取当前所处的冬夏时令的每节课的时间，以及上课节次,已按节次排序
        List<SchoolTimeDetail> detailList = judgeSchoolTime();
        //班级所处学期的课程表数据
        LambdaQueryWrapper<SchoolTimeTable> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotNull(schoolTimeTable.getClassId()),SchoolTimeTable::getClassId,schoolTimeTable.getClassId())
                .eq(isNotNull(schoolTimeTable.getTermId()),SchoolTimeTable::getTermId,schoolTimeTable.getTermId())
        ;
        List<SchoolTimeTable> tableList = schoolTimeTableMapper.selectList(lqw);

        List<TableVO> list  = new ArrayList<>();
        //处理数据，按第几节，周一到周日都有什么课
        for(SchoolTimeDetail detail : detailList){
            //设置当前是第几节课
            TableVO vo = new TableVO();
            BeanUtils.copyProperties(detail,vo);
            //存放周一到周天的课
            List<SchoolTimeTable> voList = new ArrayList<>();

            //获取本节次周一到周天的课
            for(SchoolTimeTable table : tableList){
                if(detail.getSortId().equals(table.getSortId())){
                    voList.add(table);
                }
            }

            //设置本节次周一到周天的课
            vo = setCourse(null,vo,voList);
            list.add(vo);
        }
        //给课表中周一到周日各节次中的null赋值空对象
        return dealTable(list);
    }

    /**
     * 课程表新增或修改
     */
    @Override
    public int addSchoolSchedule(List<TableVO> list, Long classId, Integer termId) {
        //先删再增
        LambdaQueryWrapper<SchoolTimeTable> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolTimeTable::getClassId,classId).eq(SchoolTimeTable::getTermId,termId);
        schoolTimeTableMapper.delete(lqw);

        //处理数据
        List<SchoolTimeTable> tableList = dealTimeTable(list,classId,termId);
        int num = 0;
        for(SchoolTimeTable table : tableList){
            num += schoolTimeTableMapper.insert(table);
        }
        return tableList.size() == num ? 1 : 0;
    }

    /**将数据处理成可以存课表的样子*/
    public List<SchoolTimeTable> dealTimeTable(List<TableVO> list, Long classId,Integer termId){
        List<SchoolTimeTable> tableList = new ArrayList<>();
        //获取班级信息
        SchoolClass c = schoolClassMapper.selectById(classId);
        for(TableVO vo : list){
            //处理本节次星期日到星期日的课程信息
            for(int i = 1 ; i<= 7;i++){
                SchoolCourseVO courseVO = new SchoolCourseVO();
                String weekName="";
                if(i==1){
                    //判断传过来的星期一有没有课程
                    courseVO = vo.getMonday();
                    if(StringUtils.isNull(courseVO.getCourseName())){
                        continue;
                    }
                    weekName = MONDAY;
                } else if (i==2) {
                    courseVO = vo.getTuesday();
                    if(StringUtils.isNull(courseVO.getCourseName())){
                        continue;
                    }
                    weekName = TUESDAY;
                } else if (i==3) {
                    courseVO = vo.getWednesday();
                    if(StringUtils.isNull(courseVO.getCourseName())){
                        continue;
                    }
                    weekName = WEDNESDAY;
                } else if (i==4) {
                    courseVO = vo.getThursday();
                    if(StringUtils.isNull(courseVO.getCourseName())){
                        continue;
                    }
                    weekName = THURSDAY;
                } else if (i==5) {
                    courseVO = vo.getFriday();
                    if(StringUtils.isNull(courseVO.getCourseName())){
                        continue;
                    }
                    weekName = FRIDAY;
                } else if (i==6) {
                    courseVO = vo.getSaturday();
                    if(StringUtils.isNull(courseVO.getCourseName())){
                        continue;
                    }
                    weekName = SATURDAY;
                }else {
                    courseVO = vo.getSunday();
                    if(StringUtils.isNull(courseVO.getCourseName())){
                        continue;
                    }
                    weekName = SUNDAY;
                }
                SchoolTimeTable table = new SchoolTimeTable();
                table.setYearValue(c.getSchoolYear());
                table.setGradeId(c.getGradeId());
                table.setGradeName(c.getGradeName());
                table.setClassId(classId);
                table.setClassName(c.getClassName());
                table.setWeekValue(i);
                table.setWeekName(weekName);
                table.setCourseId(courseVO.getId());
                table.setCourseTitle(courseVO.getCourseName());
                table.setSortId(vo.getSortId());
                table.setSortName(vo.getSortName());
                table.setTermId(termId);
                table.setTermName(getTermName(termId));
                table.insert();
                tableList.add(table);
            }

        }
        return tableList;
    }

    //根据上下学期值
    public String getTermName(int i){
        if(i == 0){
            return "上学期";
        }
        return "下学期";
    }

    //给课表中周一到周日各节次中的null赋值空对象
    public List<TableVO> dealTable(List<TableVO> list){
        for(TableVO vo : list){
            SchoolCourseVO courseVO = new SchoolCourseVO();
            //遍历list对象中周一到周日是否存在null,如果存在则赋值空对象
            if(isNull(vo.getMonday())){
                vo.setMonday(courseVO);
            }
            if(isNull(vo.getTuesday())){
                vo.setTuesday(courseVO);
            }
            if(isNull(vo.getWednesday())){
                vo.setWednesday(courseVO);
            }
            if(isNull(vo.getThursday())){
                vo.setThursday(courseVO);
            }
            if(isNull(vo.getFriday())){
                vo.setFriday(courseVO);
            }
            if(isNull(vo.getSaturday())){
                vo.setSaturday(courseVO);
            }
            if(isNull(vo.getSunday())){
                vo.setSunday(courseVO);
            }
        }
        return list;
    }

    //教师个人上课课程表
    @Override
    public List<TableVO> getTeacherTable(Long teacherId){
        //获取当前教师所授课班级(当前学年)
        int schoolYear = HolidayDateUtil.getSchoolYear();
        List<SchoolClassMentor> mentorList = classMentorMapper.getMentorByTeacherId(teacherId,schoolYear);
        if(isNull(mentorList)){
            return new ArrayList<>();
        }
        List<Long> classIds = mentorList.stream().map(SchoolClassMentor::getClassId).collect(Collectors.toList());

        //获取当前所处学期
        int termId = isNewTerm();
        //获取当前所处的冬夏时令的每节课的时间，以及上课节次,已按节次排序
        List<SchoolTimeDetail> detailList = judgeSchoolTime();

        List<TableVO> list = new ArrayList<>();
        for(SchoolTimeDetail detail : detailList){
            //设置当前是第几节课
            TableVO vo = new TableVO();
            BeanUtils.copyProperties(detail,vo);
            //存放本节次周一到周天的课
            List<SchoolTimeTable> voList = new ArrayList<>();
            //班级，学期，课程id，节次
            for(SchoolClassMentor mentor : mentorList){
                List<SchoolTimeTable> tableList = schoolTimeTableMapper.getTeacherTable(mentor.getClassId(),termId,mentor.getCourseId(),detail.getSortId(),teacherId);
                if (StringUtils.isNotNull(tableList)){
                    tableList.stream().forEach(t -> {
                        voList.add(t);
                    });
                }
            }

            //设置本节次周一到周天的课
            vo = setCourse(teacherId,vo,voList);
            list.add(vo);
        }
        return list;
    }

    //判断所处学期是上还是下学期
    private Integer isNewTerm() {
        Calendar cal = Calendar.getInstance();
        //获取当前年月
        int nowYear = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        //设置当前学期为上学期
        int term = 0;
        //2-7为下学期，8-1为上学期
        if (month >= 2 && month < 8) {
            term = 1;
        }
        return term;
    }

    //设置本节次星期一到星期日的课程
    public TableVO setCourse(Long teacherId,TableVO vo,List<SchoolTimeTable> tableList){
        for(SchoolTimeTable table : tableList){
            SchoolCourseVO courseVO = new SchoolCourseVO();
            courseVO.setId(table.getCourseId());
            if(isNull(teacherId)){
                courseVO.setCourseName(table.getCourseTitle());
            } else{
                //取班级别名
                SchoolClass schoolClass = schoolClassMapper.selectById(table.getClassId());
                String courseName = schoolClass.getClassAlias() + table.getCourseTitle();
                courseVO.setCourseName(courseName);
            }

            switch (table.getWeekValue()){
                case 1:
                    vo.setMonday(courseVO);break;
                case 2:
                    vo.setTuesday(courseVO);break;
                case 3:
                    vo.setWednesday(courseVO);break;
                case 4:
                    vo.setThursday(courseVO);break;
                case 5:
                    vo.setFriday(courseVO);break;
                case 6:
                    vo.setSaturday(courseVO);break;
                case 7:
                    vo.setSunday(courseVO);break;
            }
        }
        return vo;
    }

    /**
     * 判断当前所处的冬夏时刻，返回节次时间
     */
    public List<SchoolTimeDetail> judgeSchoolTime(){
        //冬夏时令，按理说，当前应只有一个正在使用
        LambdaQueryWrapper<SchoolTime> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolTime::getIsUsed,USE);
        //如果查出多个，则选择第一个作为当前时令
        List<SchoolTime> schoolTimes = schoolTimeMapper.selectList(lqw);
        if(StringUtils.isNull(schoolTimes) || schoolTimes.size() == 0){
            throw new ServiceException("抱歉，当前并没有学校时刻在使用，无法查出课程节次信息，请联系管理员");
        }
        SchoolTime schoolTime = schoolTimes.get(0);
        //获取当前时令的上课节次，时间等
        LambdaQueryWrapper<SchoolTimeDetail> qw = new LambdaQueryWrapper<>();
        qw.eq(SchoolTimeDetail::getSchoolTimeId,schoolTime.getId()).orderByAsc(SchoolTimeDetail::getSortId);
        List<SchoolTimeDetail> list = schoolTimeDetailMapper.selectList(qw);
        if(isNull(list)){
            throw new ServiceException("当前时令还没有设置节次");
        }
        return list;
    }

    /**
     * 导出 课程表
     */
    @Override
    public List<SchoolCourseSchedule> getCourseSchedule(SchoolTimeTable schoolTimeTable) {
        //判断是否传 年级 班级 学年  时刻id (schoolTimeId例如上学期，下学期 这里是夏季时刻的id）
        //查出相应 学年 班级 时刻 的数据列表
        List<SchoolCourseTableVO> schoolCourseTables = schoolTimeTableMapper.selectSchoolTimeTableList(schoolTimeTable);
        if (isNull(schoolCourseTables)) {
            throw new BaseException("此班级还未添加课程!");
        }
   //     Long schoolTimeId = schoolTimeTable.getSchoolTimeId();
        Long schoolTimeId = null;
        //将课程名称绑定进课程表
        List<SchoolCourseSchedule> schoolCourseSchedules = makeCourseSchedule(schoolCourseTables,schoolTimeId);
        return schoolCourseSchedules;
    }

    /*
     * 制作课程表
     * */
    public List<SchoolCourseSchedule> makeCourseSchedule(List<SchoolCourseTableVO> schoolCourseTables, Long schoolTimeId) {
        //根据时刻 里的time_sort分类 获取纵坐标
        SchoolTimeDetail schoolTimeDetail = new SchoolTimeDetail();
        schoolTimeDetail.setSchoolTimeId(schoolTimeId);
        List<SchoolTimeDetailVO> schoolTimeDetails = schoolTimeDetailMapper.selectSchoolTimeDetailList(schoolTimeDetail);

        if (schoolTimeDetails.size() == 0) {
            throw new BaseException("请添加时刻!");
        }
        List<SchoolCourseSchedule> schoolCourseSchedules = new ArrayList<>();

        for (SchoolTimeDetailVO timeDetail : schoolTimeDetails) {
            SchoolCourseSchedule schoolCourseSchedule = new SchoolCourseSchedule();
            //设置时刻名称
            schoolCourseSchedule.setSortName(timeDetail.getSortName());
            //设置开始时间
            schoolCourseSchedule.setStartTime(timeDetail.getStartTime());
            //设置结束时间
            schoolCourseSchedule.setEndTime(timeDetail.getEndTime());

            //制作横坐标 星期
            for (SchoolCourseTableVO schoolCourseTable : schoolCourseTables) {
                if (timeDetail.getSortId().equals(schoolCourseTable.getSortId())) {
                    setWeek(schoolCourseSchedule, schoolCourseTable);
                }
            }
            schoolCourseSchedules.add(schoolCourseSchedule);
        }
        return schoolCourseSchedules;
    }

    /*
     * 根据星期设置
     * */
    public SchoolCourseSchedule setWeek(SchoolCourseSchedule schoolCourseSchedule, SchoolCourseTableVO schoolCourseTable) {
        LambdaQueryWrapper<SchoolCourse> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolCourse::getId, schoolCourseTable.getCourseId());
        SchoolCourse schoolCourse = schoolCourseMapper.selectOne(lqw);
        SchoolCourseVO schoolCourseVO = new SchoolCourseVO();
        BeanUtils.copyProperties(schoolCourse, schoolCourseVO);
        switch (schoolCourseTable.getWeekValue()) {
            case 1:
                schoolCourseSchedule.setMonday(schoolCourseVO);
                break;
            case 2:
                schoolCourseSchedule.setTuesday(schoolCourseVO);
                break;
            case 3:
                schoolCourseSchedule.setWednesday(schoolCourseVO);
                break;
            case 4:
                schoolCourseSchedule.setThursday(schoolCourseVO);
                break;
            case 5:
                schoolCourseSchedule.setFriday(schoolCourseVO);
                break;
            case 6:
                schoolCourseSchedule.setSaturday(schoolCourseVO);
                break;
            case 7:
                schoolCourseSchedule.setSunday(schoolCourseVO);
                break;
        }
        return schoolCourseSchedule;
    }

    /*
    * 微信  通过userId获取班级信息
    * */
    @Override
    public SchoolTimeTable setGradeAndTime(Long studentId) {
        SchoolTimeTable schoolTimeTable=new SchoolTimeTable();
        //我这里先绑定是夏季时刻
        //获取冬夏时刻，只有一个时刻在用，查出来
        LambdaQueryWrapper<SchoolTime> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(SchoolTime::getIsUsed,"1");
        SchoolTime schoolTime = schoolTimeMapper.selectList(lambdaQueryWrapper).get(0);
        //schoolTimeTable.setSchoolTimeId(Integer.toUnsignedLong(4));
       // schoolTimeTable.setSchoolTimeId(schoolTime.getId());

        LambdaQueryWrapper<SchoolStudent> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolStudent::getId,studentId);
        SchoolStudent schoolStudent = schoolStudentMapper.selectOne(lqw);
        if(isNull(schoolStudent)){
            throw new BaseException("没有这个学生!");
        }

        //如果classid 不存在就返回一个空课程表
        SchoolClass schoolClass = schoolClassMapper.selectById(schoolStudent.getClassId());
        if(StringUtils.isNotNull(schoolClass)){
            schoolTimeTable.setGradeId(Long.valueOf(schoolClass.getGradeValue()));
            schoolTimeTable.setClassId(Long.valueOf(schoolClass.getClassValue()));
            schoolTimeTable.setYearValue(schoolClass.getSchoolYear());
        }
        return schoolTimeTable;
    }

    /**公众号》学生课表*/
    @Override
    public List<TableVO> getStudentTable(Long studentId,Long classId,int termId) {
        //获取当前学生所在班级
        //SchoolStudent student = schoolStudentMapper.selectById(studentId);
        //获取当前所处学期
        //int termId = isNewTerm();
        //获取当前所处的冬夏时令的每节课的时间，以及上课节次,已按节次排序
        List<SchoolTimeDetail> detailList = judgeSchoolTime();

        //班级所处学期的课程表数据
        LambdaQueryWrapper<SchoolTimeTable> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolTimeTable::getClassId,classId)
                .eq(SchoolTimeTable::getTermId,termId)
        ;
        List<SchoolTimeTable> tableList = schoolTimeTableMapper.selectList(lqw);

        List<TableVO> list = new ArrayList<>();
        for(SchoolTimeDetail detail : detailList){
            //设置当前是第几节课
            TableVO vo = new TableVO();
            BeanUtils.copyProperties(detail,vo);
            //存放周一到周天的课
            List<SchoolTimeTable> voList = new ArrayList<>();

            //获取本节次周一到周天的课
            for(SchoolTimeTable table : tableList){
                if(detail.getSortId().equals(table.getSortId())){
                    voList.add(table);
                }
            }

            //设置本节次周一到周天的课
            vo = setCourse(null,vo,voList);
            list.add(vo);
        }
        return list;
    }

    @Override
    public Boolean exportSchedule(List<ScheduleVo> list, String path){
        try {
            String fileName = path+"课程表"+".xlsx";
            Workbook workbook = new XSSFWorkbook();
            Sheet sheet = workbook.createSheet("课程表");
            Row rowHead = sheet.createRow(0);
            rowHead.createCell(0).setCellValue("节次");
            rowHead.createCell(1).setCellValue("时间");
            rowHead.createCell(2).setCellValue("周一");
            rowHead.createCell(3).setCellValue("周二");
            rowHead.createCell(4).setCellValue("周三");
            rowHead.createCell(5).setCellValue("周四");
            rowHead.createCell(6).setCellValue("周五");
            rowHead.createCell(7).setCellValue("周六");
            rowHead.createCell(8).setCellValue("周日");
            for (int i = 0; i < list.size(); i++) {
                ScheduleVo schedule = list.get(i);
                Row row = sheet.createRow(i + 1);
                row.createCell(0).setCellValue(schedule.getSort());
                row.createCell(1).setCellValue(schedule.getTime());
                row.createCell(2).setCellValue(schedule.getMonday());
                row.createCell(3).setCellValue(schedule.getTuesday());
                row.createCell(4).setCellValue(schedule.getWednesday());
                row.createCell(5).setCellValue(schedule.getThursday());
                row.createCell(6).setCellValue(schedule.getFriday());
                row.createCell(7).setCellValue(schedule.getSaturday());
                row.createCell(8).setCellValue(schedule.getSunday());
            }
            FileOutputStream fileOutputStream = new FileOutputStream(fileName);
            workbook.write(fileOutputStream);
            workbook.close();
            return true;
        }catch (Exception e){
            return false;
        }
    }

    //导出
    @Override
    public List<ExportScheduleVo> exportTable(Long classId, Integer termId) {
        //参数必有班级id ，学期
        //获取当前所处的冬夏时令的每节课的时间，以及上课节次,已按节次排序
        List<SchoolTimeDetail> detailList = judgeSchoolTime();
        //班级所处学期的课程表数据
        LambdaQueryWrapper<SchoolTimeTable> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolTimeTable::getClassId,classId)
                .eq(SchoolTimeTable::getTermId,termId)
        ;
        List<SchoolTimeTable> tableList = schoolTimeTableMapper.selectList(lqw);

        List<ExportScheduleVo> list  = new ArrayList<>();
        //处理数据，按第几节，周一到周日都有什么课
        for(SchoolTimeDetail detail : detailList){
            //设置当前是第几节课
            ExportScheduleVo vo = new ExportScheduleVo();
            BeanUtils.copyProperties(detail,vo);
            //存放周一到周天的课
            List<SchoolTimeTable> voList = new ArrayList<>();

            //获取本节次周一到周天的课
            for(SchoolTimeTable table : tableList){
                if(detail.getSortId().equals(table.getSortId())){
                    voList.add(table);
                }
            }

            //设置本节次周一到周天的课
            vo = settingExport(vo,voList);
            list.add(vo);
        }
        return list;
    }

    //导入校验
    @Override
    public void checkImport(List<ExportScheduleVo> list) {
        //检验是否为空
        if (StringUtils.isNull(list) || list.size() == 0) {
            throw new ServiceException("导入数据不能为空");
        }
        // 准备记录日志数据
        int failureNum = 0;
        StringBuilder failureMsg = new StringBuilder();
        for (ExportScheduleVo exportScheduleVo : list) {
            if (StringUtils.isEmpty(exportScheduleVo.getSortName())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、节次为空,请您重新输入! ");
            } /*else if (StringUtils.isNull(exportScheduleVo.getStartTime())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、开始时间为空,请您重新输入! ");
            } else if (StringUtils.isNull(exportScheduleVo.getEndTime())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、结束时间为空,请您重新输入! ");
            }*/
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共 " + failureNum + " 条数据格式不正确，错误如下：");
            throw new ServiceException(failureMsg.toString());
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String importData(List<ExportScheduleVo> list,Long classId, Integer termId) {
        // 准备记录日志数据
        int successNum = 0;
        StringBuilder successMsg = new StringBuilder();
        //先删再增
        LambdaQueryWrapper<SchoolTimeTable> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolTimeTable::getClassId,classId).eq(SchoolTimeTable::getTermId,termId);
        schoolTimeTableMapper.delete(lqw);

        //处理数据
        List<SchoolTimeTable> tableList = dealExportTimeTable(list,classId,termId);
        // 遍历并逐个导入
        for (SchoolTimeTable vo : tableList) {
            try {
                schoolTimeTableMapper.insert(vo);
                successNum++;
                //successMsg.append("<br/>" + successNum + "数据" + " 导入成功");
            } catch (Exception e) {
                throw new ServiceException("导入失败");
            }
        }
        successMsg.insert(0, "恭喜您，数据已导入成功！共有 " + successNum + " 条");
        return successMsg.toString();
    }

    //将导入的数据处理成可以添加到数据库的样子
    public List<SchoolTimeTable> dealExportTimeTable(List<ExportScheduleVo> list, Long classId,Integer termId){
        List<SchoolTimeTable> tableList = new ArrayList<>();
        //获取班级信息
        SchoolClass c = schoolClassMapper.selectById(classId);
        //获取当前所处的冬夏时令的每节课的时间，以及上课节次,已按节次排序
        List<SchoolTimeDetail> detailList = judgeSchoolTime();

        for(ExportScheduleVo vo : list){
            int sortId = 0;
            //获取节次id
            for(SchoolTimeDetail detail : detailList){
                if(detail.getSortName().equals(vo.getSortName())){
                    sortId = detail.getSortId();
                    break;
                }
            }

            //处理本节次星期yi到星期日的课程信息
            for(int i = 1 ; i<= 7;i++){
                String weekName="";
                String courseName="";
                if(i==1){
                    //判断传过来的星期一有没有课程
                    if(StringUtils.isNull(vo.getMonday())){
                        continue;
                    }
                    weekName = MONDAY;
                    courseName = vo.getMonday();
                } else if (i==2) {
                    if(StringUtils.isNull(vo.getTuesday())){
                        continue;
                    }
                    weekName = TUESDAY;
                    courseName = vo.getTuesday();
                } else if (i==3) {
                    if(StringUtils.isNull(vo.getWednesday())){
                        continue;
                    }
                    weekName = WEDNESDAY;
                    courseName = vo.getWednesday();
                } else if (i==4) {
                    if(StringUtils.isNull(vo.getThursday())){
                        continue;
                    }
                    weekName = THURSDAY;
                    courseName = vo.getThursday();
                } else if (i==5) {
                    if(StringUtils.isNull(vo.getFriday())){
                        continue;
                    }
                    weekName = FRIDAY;
                    courseName = vo.getFriday();
                } else if (i==6) {
                    if(StringUtils.isNull(vo.getSaturday())){
                        continue;
                    }
                    weekName = SATURDAY;
                    courseName = vo.getSaturday();
                }else {
                    if(StringUtils.isNull(vo.getSunday())){
                        continue;
                    }
                    weekName = SUNDAY;
                    courseName = vo.getSunday();
                }
                LambdaQueryWrapper<SchoolCurriculum> lqw = new LambdaQueryWrapper<>();
                lqw.eq(SchoolCurriculum::getCourseName,courseName);
                List<SchoolCurriculum> sc = schoolCurriculumService.list(lqw);
                if(StringUtils.isNotNull(sc) && sc.size() > 0){
                    SchoolTimeTable table = new SchoolTimeTable();
                    table.setYearValue(c.getSchoolYear());
                    table.setGradeId(c.getGradeId());
                    table.setGradeName(c.getGradeName());
                    table.setClassId(classId);
                    table.setClassName(c.getClassName());
                    table.setWeekValue(i);
                    table.setWeekName(weekName);
                    table.setCourseId(sc.get(0).getId());
                    table.setCourseTitle(courseName);
                    table.setSortId(sortId);
                    table.setSortName(vo.getSortName());
                    table.setTermId(termId);
                    table.setTermName(getTermName(termId));
                    table.insert();
                    tableList.add(table);
                }
            }

        }
        return tableList;
    }

    //导出设置本节次星期一到星期日的课程
    public ExportScheduleVo settingExport(ExportScheduleVo vo,List<SchoolTimeTable> tableList){
        for(SchoolTimeTable table : tableList){
            String course = table.getCourseTitle();
            switch (table.getWeekValue()){
                case 1:
                    vo.setMonday(course);break;
                case 2:
                    vo.setTuesday(course);break;
                case 3:
                    vo.setWednesday(course);break;
                case 4:
                    vo.setThursday(course);break;
                case 5:
                    vo.setFriday(course);break;
                case 6:
                    vo.setSaturday(course);break;
                case 7:
                    vo.setSunday(course);break;
            }
        }
        return vo;
    }

    @Override
    public Boolean importExcel(SchoolTimeTable timeTable,MultipartFile file) {
        if(StringUtils.isNotNull(timeTable.getTermName())){
            if(timeTable.getTermName().equals("上学期")){
                timeTable.setTermId(0);
            }
            if(timeTable.getTermName().equals("下学期")){
                timeTable.setTermId(1);
            }
        }
        List<SchoolTimeDetail> detailList = judgeSchoolTime();
        try{
            InputStream in = file.getInputStream();
            XSSFWorkbook sheets = new XSSFWorkbook(in);  //读取整个excel
            XSSFSheet sheet = sheets.getSheetAt(0);  //获取第一个sheet
            int rowNum = 0;
            //存在样式的空行,会被统计进来,判断是否是空行。
            for (int num = 0; num <=sheet.getLastRowNum(); num++) {
                XSSFRow row = sheet.getRow(num);
                if (StringUtils.isNotNull(row)) {
                    rowNum++;
                }
            }
            String courseName = null;
            for(int i=1;i<rowNum;i++){
                XSSFRow row = sheet.getRow(i);
                Integer sortId = null;
                String sortName = null;
                for(SchoolTimeDetail schoolTimeDetail : detailList){
                    if(row.getCell(0).getStringCellValue().equals(schoolTimeDetail.getSortName())){
                        sortId = schoolTimeDetail.getSortId();
                        sortName = schoolTimeDetail.getSortName();
                    }
                }
                for(int j = 2;j<9;j++){
                    if(StringUtils.isNotNull(row.getCell(j))){
                        SchoolTimeTable schoolTimeTable = new SchoolTimeTable();
                        BeanUtils.copyProperties(timeTable,schoolTimeTable);
                        courseName = row.getCell(j).getStringCellValue();
                        schoolTimeTable.setCourseTitle(courseName);
                        schoolTimeTable.setCourseId(schoolCurriculumService.selectByName(courseName).getId());
                        schoolTimeTable.setSortId(sortId);
                        schoolTimeTable.setSortName(sortName);
                        schoolTimeTable.setWeekValue(j-1);
                        schoolTimeTable.setWeekName(sheet.getRow(0).getCell(j).getStringCellValue());
                        schoolTimeTableMapper.insert(schoolTimeTable);
                    }
                }
            }
            return true;
        }catch (Exception e){
            throw new ServiceException("导入失败");
        }
    }



    /**
     * 导入试题数据
     *
     * @param list 数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @return 结果
     */
//    @Override
//    public String importExamDetailSchedule(List<SchoolSchedule> list, Boolean isUpdateSupport,
//                                           SchoolTimeTable schoolTimeTable)
//    {
//        if (StringUtils.isNull(list) || list.size() == 0) {
//            throw new BusinessException("导入课程表数据不能为空！");
//        }
//        int successNum = 0;
//        int failureNum = 0;
//        StringBuilder successMsg = new StringBuilder();
//        StringBuilder failureMsg = new StringBuilder();
//        for (int i = 0; i < list.size(); i++) {//循环课程表的每一行。（第一节课 周一到周日）
//            SchoolSchedule schoolSchedule = list.get(i);
//            int iSort = i + 1; // i 用作排序 需要加1
//            String theWeekName = "";//中间保存 星期一到日
//
//            //从导入excel取 年级班级值，从 school_grade表 判断是否存在，并取值设置到 schoolTimeTable 去，下面循环周1-7使用
//            Integer gradeValue = schoolSchedule.getGradeValue();
//            Integer classValue = schoolSchedule.getClassValue();
//
//            SchoolGrade grade = new SchoolGrade();
////            grade.setIsUsed(new Integer(0));//使用中
////            grade.setIsUsed(new Integer(0));//使用中
//            grade.setGradeValue(gradeValue);
//            grade.setClassValue(classValue);
//            List<SchoolGrade> listGrade = ISchoolGradeService.selectSchoolGradeList(grade);
//            if (listGrade.size() > 0){
//                grade = listGrade.get(0);
//                schoolTimeTable.setYearValue(grade.getSchoolYear());
//                schoolTimeTable.setGradeValue(grade.getGradeValue());
//                schoolTimeTable.setGradeName(grade.getGradeName());
//                schoolTimeTable.setClassValue(grade.getClassValue());
//                schoolTimeTable.setClassName(grade.getClassName());
//                schoolTimeTable.setTimeSort(schoolSchedule.getTimeSort());
//            } else {//年级班级不存在
//                failureNum++;
//                failureMsg.append("<br/>" + failureNum + "、年级"+
//                        gradeValue + " 班级 " + classValue + " 不存在");
//                continue;
//            }
//
//            for (int w = 1; w<= 7; w++) {//循环每一行的 周一到周日
//                try {
//                    // 初始化对象，并将传递的参数 入学年级班级等复制过来
//                    SchoolTimeTable inSchoolTimeTable = new SchoolTimeTable();
//                    BeanUtils.copyProperties(schoolTimeTable, inSchoolTimeTable);
//                    // 从 SchoolSchedule 中获取课程信息，设置到 inSchoolTimeTable 中
//                    String theCourseTitle = "";//中间保存 当前课程
//                    inSchoolTimeTable.setWeekValue(w);//设置周几 数值
//                    switch (w){
//                        case 1:
//                            theWeekName = "周一";
//                            theCourseTitle = schoolSchedule.getMonday();
//                            break;
//                        case 2:
//                            theWeekName = "周二";
//                            theCourseTitle = schoolSchedule.getTuesday();
//                            break;
//                        case 3:
//                            theWeekName = "周三";
//                            theCourseTitle = schoolSchedule.getWednesday();
//                            break;
//                        case 4:
//                            theWeekName = "周四";
//                            theCourseTitle = schoolSchedule.getThursday();
//                            break;
//                        case 5:
//                            theWeekName = "周五";
//                            theCourseTitle = schoolSchedule.getFriday();
//                            break;
//                        case 6:
//                            theWeekName = "周六";
//                            theCourseTitle = schoolSchedule.getSaturday();
//                            break;
//                        case 7:
//                            theWeekName = "周日";
//                            theCourseTitle = schoolSchedule.getSunday();
//                            break;
//                    }
//
//                    // 验证是否已存在
//                    boolean isExistsFlag = false;
//                    long stId = 0; // 如果存在，更新的话，获取试题ID
//
//                    List<SchoolTimeTable> tmpl = selectSchoolTimeTableList(inSchoolTimeTable);
//                    if (tmpl.size() > 0) {
//                        isExistsFlag = true;
//                        stId = tmpl.get(0).getId();
//                    }
//
//                    // 设置 课程信息
//                    inSchoolTimeTable.setCourseTitle(theCourseTitle);//设置课程名
//                    inSchoolTimeTable.setWeekName(theWeekName);//设置周几 名称
//                    // 如果 inSchoolTimeTable.getCourseTitle 空。表示这节没设置课程。
//                    if(StringUtils.isEmpty(inSchoolTimeTable.getCourseTitle())){
//                        inSchoolTimeTable.setCourseTitle(" ");
//                    }
//
//                    if (!isExistsFlag) {
//                        insertSchoolTimeTable(inSchoolTimeTable);
//                        successNum++;
//                        successMsg.append("<br/>" + successNum + "、" +
//                                theWeekName + " 课时 " + inSchoolTimeTable.getTimeSort() + " 导入成功");
//                    } else if (isUpdateSupport) {
//                        inSchoolTimeTable.setId(stId);
//                        updateSchoolTimeTable(inSchoolTimeTable);
//                        successNum++;
//                        successMsg.append("<br/>" + successNum + "、"+
//                                theWeekName + " 课时 " + inSchoolTimeTable.getTimeSort() + " 更新成功");
//                    } else {
//                        failureNum++;
//                        failureMsg.append("<br/>" + failureNum + "、"+
//                                theWeekName + " 课时 " + inSchoolTimeTable.getTimeSort() + " 已存在");
//                    }
//                }
//                catch (Exception e) {
//                    failureNum++;
//                    String msg = "<br/>" + failureNum + "、"+
//                            theWeekName + " 课时 " + iSort + " 导入失败：";
//
//                    failureMsg.append(msg + e.getCause().getMessage());
//                }
//            }// end for 循环每一行的 周一到周日
//        }// end for 循环课程表的每一行。（第一节课 周一到周日）
//        if (failureNum > 0) {
//            failureMsg.insert(0, "很抱歉，导入失败！共 " + failureNum + " 条数据格式不正确，错误如下：");
//            throw new BusinessException(failureMsg.toString());
//        } else {
//            successMsg.insert(0, "恭喜您，数据已全部导入成功！共 " + successNum + " 条，数据如下：");
//        }
//        return successMsg.toString();
//    }


    /**
     * 课程表树形结构
     */
    @Override
    public List<Ztree> selectSchoolClassListForTreeNew(SchoolClass schoolClass) {
        List<SchoolClass> list = schoolClassMapper.selectSchoolClassListForTreeNew(schoolClass);
        List<Ztree> ztrees = initZtree(list);
        return ztrees;
    }

    /**
     * 加载 整个班级列表
     */
    @Override
    public List<SchoolClass> getSchoolClassList(SchoolClass schoolClass) {
        return schoolClassMapper.selectSchoolClassListForTreeNew(schoolClass);
    }

    /**
     * 微信公众号获取课表
     *
     * @param schoolTimeTableVo
     * @return
     */
    @Override
    public List<SchoolTimeTableVo> getSchoolSchedule(SchoolTimeTableVo schoolTimeTableVo) {
        return schoolTimeTableMapper.getSchoolSchedule(schoolTimeTableVo);
    }

    @Override
    public void saveSchedule(List<SchoolSchedule> list) {
        for(Integer i=0;i<list.size();i++){
            SchoolSchedule schoolSchedule = list.get(i);
//            SchoolTimeDetail schoolTimeDetail = schoolTimeDetailMapper.selectBySort(schoolSchedule.getTimeSort());
            SchoolTimeTable schoolTimeTable = new SchoolTimeTable();
            schoolTimeTable.setYearValue(schoolSchedule.getYearValue());
            schoolTimeTable.setGradeId(Long.valueOf(schoolSchedule.getGradeValue()));
            schoolTimeTable.setGradeName(schoolSchedule.getGradeValue()+"年级");
            schoolTimeTable.setClassId(Long.valueOf(schoolSchedule.getClassValue()));
            schoolTimeTable.setClassName(schoolSchedule.getClassValue()+"班");
           // schoolTimeTable.setSchoolTimeId(schoolSchedule.getSeason());  //季节
            schoolTimeTable.setSortId(schoolSchedule.getTimeSort());
            if(StringUtils.isNotNull(schoolSchedule.getMonday()) && schoolSchedule.getMonday()!=""){
                schoolTimeTable.setWeekValue(1);   //表示星期几
                schoolTimeTable.setWeekName("星期一");
                schoolTimeTable.setCourseId(Long.valueOf(schoolSchedule.getMondayId()));
                schoolTimeTable.setCourseTitle(schoolSchedule.getMonday());
                schoolTimeTableMapper.insert(schoolTimeTable);
            }
            if(StringUtils.isNotNull(schoolSchedule.getTuesday()) && schoolSchedule.getTuesday()!=""){
                schoolTimeTable.setWeekValue(2);    //表示星期几
                schoolTimeTable.setWeekName("星期二");
                schoolTimeTable.setCourseId(Long.valueOf(schoolSchedule.getTuesdayId()));
                schoolTimeTable.setCourseTitle(schoolSchedule.getTuesday());
                schoolTimeTableMapper.insert(schoolTimeTable);
            }
            if(StringUtils.isNotNull(schoolSchedule.getWednesday()) && schoolSchedule.getWednesday()!=""){
                schoolTimeTable.setWeekValue(3);    //表示星期几
                schoolTimeTable.setWeekName("星期三");
                schoolTimeTable.setCourseId(Long.valueOf(schoolSchedule.getWednesdayId()));
                schoolTimeTable.setCourseTitle(schoolSchedule.getWednesday());
                schoolTimeTableMapper.insert(schoolTimeTable);
            }
            if(StringUtils.isNotNull(schoolSchedule.getThursday()) && schoolSchedule.getThursday()!=""){
                schoolTimeTable.setWeekValue(4);    //表示星期几
                schoolTimeTable.setWeekName("星期四");
                schoolTimeTable.setCourseId(Long.valueOf(schoolSchedule.getThursdayId()));
                schoolTimeTable.setCourseTitle(schoolSchedule.getThursday());
                schoolTimeTableMapper.insert(schoolTimeTable);
            }
            if(StringUtils.isNotNull(schoolSchedule.getFriday()) && schoolSchedule.getFriday()!=""){
                schoolTimeTable.setWeekValue(5);    //表示星期几
                schoolTimeTable.setWeekName("星期五");
                schoolTimeTable.setCourseId(Long.valueOf(schoolSchedule.getFridayId()));
                schoolTimeTable.setCourseTitle(schoolSchedule.getFriday());
                schoolTimeTableMapper.insert(schoolTimeTable);
            }
            if(StringUtils.isNotNull(schoolSchedule.getSaturday()) && schoolSchedule.getSaturday()!=""){
                schoolTimeTable.setWeekValue(6);    //表示星期几
                schoolTimeTable.setWeekName("星期六");
                schoolTimeTable.setCourseId(Long.valueOf(schoolSchedule.getSaturdayId()));
                schoolTimeTable.setCourseTitle(schoolSchedule.getSaturday());
                schoolTimeTableMapper.insert(schoolTimeTable);
            }
            if(StringUtils.isNotNull(schoolSchedule.getSunday()) && schoolSchedule.getSunday()!=""){
                schoolTimeTable.setWeekValue(7);    //表示星期几
                schoolTimeTable.setWeekName("星期天");
                schoolTimeTable.setCourseId(Long.valueOf(schoolSchedule.getSundayId()));
                schoolTimeTable.setCourseTitle(schoolSchedule.getSunday());
                schoolTimeTableMapper.insert(schoolTimeTable);
            }
        }

    }

    /**
     *获取老师课表
     */
    @Override
    public List<SchoolTimeTableVo> getTimeTable(Long teacherId) {
        List<SchoolTimeTableVo> list = schoolTimeTableMapper.getTimeTable(teacherId);
//        list.stream().collect(Collectors.groupingBy(SchoolTimeTableVo::getWeekValue));
        return list;
    }

    /**
     * 获取到的年级班级信息 转树形结构
     *
     * @param list 部门列表
     * @return 树结构列表
     */
    public List<Ztree> initZtree(List<SchoolClass> list) {
        List<Ztree> ztrees = new ArrayList<Ztree>();
        for (SchoolClass sg : list) {
            Ztree ztree = new Ztree();
            Ztree ztree1 = new Ztree();
            // 取得数据
            Integer gradeValue = sg.getGradeValue();// 0
            String gradeName = sg.getGradeName();// 一年级
            Integer classValue = sg.getClassValue();// 0
            String className = sg.getClassName();// 一班
            Integer schoolYear = sg.getSchoolYear(); //2021 年入学
            Integer schoolYearValue = schoolYear;

            if (ztrees.isEmpty()) {
                Integer id = gradeValue;
                Long pId = new Long(-1);
                String name = gradeName;
                String title = gradeName;
                ztree.setId(id.longValue());
                ztree.setpId(pId);
                ztree.setName(name);
                ztree.setTitle(title);
                ztrees.add(ztree);

                id = schoolYearValue * 1000 + gradeValue * 100 + classValue;
                pId = gradeValue.longValue();
                name = className;
                title = className;
                ztree1.setId(id.longValue());
                ztree1.setpId(pId);
                ztree1.setName(name);
                ztree1.setTitle(title);
                ztrees.add(ztree1);
            } else {
                int num = 0;
                for (Ztree z : ztrees) {
                    if (gradeValue.longValue() == z.getId()) {
                        Integer id = schoolYearValue * 1000 + gradeValue * 100 + classValue;
                        Integer pId = gradeValue;
                        String name = className;
                        String title = className;
                        ztree1.setId(id.longValue());
                        ztree1.setpId(pId.longValue());
                        ztree1.setName(name);
                        ztree1.setTitle(title);
                        ztrees.add(ztree1);
                        ztrees.size();
                        break;
                    } else {
                        num = num + 1;
                        if (num == ztrees.size()) {
                            Integer id = gradeValue;
                            Long pId = new Long(-1);
                            String name = gradeName;
                            String title = gradeName;
                            ztree.setId(id.longValue());
                            ztree.setpId(pId);
                            ztree.setName(name);
                            ztree.setTitle(title);
                            ztrees.add(ztree);

                            id = schoolYearValue * 1000 + gradeValue * 100 + classValue;
                            pId = gradeValue.longValue();
                            name = className;
                            title = className;
                            ztree1.setId(id.longValue());
                            ztree1.setpId(pId);
                            ztree1.setName(name);
                            ztree1.setTitle(title);
                            ztrees.add(ztree1);
                            break;
                        }
                    }
                }
            }
        }
        return ztrees;
    }
}
