package yangtz.cs.liu.campus.service.impl.teacher;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherResume;
import yangtz.cs.liu.campus.mapper.teacher.SchoolTeacherResumeMapper;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherResumeService;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

@Service
public class SchoolTeacherResumeServiceImpl extends ServiceImpl<SchoolTeacherResumeMapper,SchoolTeacherResume> implements ISchoolTeacherResumeService {

    @Autowired
    private SchoolTeacherResumeMapper schoolTeacherResumeMapper;

    @Override
    public List<SchoolTeacherResume> queryList(SchoolTeacherResume schoolTeacherResume) {
        LambdaQueryWrapper<SchoolTeacherResume> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotNull(schoolTeacherResume.getTeacherId()), SchoolTeacherResume::getTeacherId, schoolTeacherResume.getTeacherId())
                .like(isNotBlank(schoolTeacherResume.getLearnSchool()), SchoolTeacherResume::getLearnSchool, schoolTeacherResume.getLearnSchool())
                .lt(isNotNull(schoolTeacherResume.getLearnStart()), SchoolTeacherResume::getLearnStart, schoolTeacherResume.getLearnStart())
                .gt(isNotNull(schoolTeacherResume.getLearnEnd()), SchoolTeacherResume::getLearnEnd, schoolTeacherResume.getLearnEnd());

        return schoolTeacherResumeMapper.selectList(lqw);
//        return schoolTeacherResumeMapper.queryList(schoolTeacherResume);
    }
}
