package yangtz.cs.liu.campus.service.impl.teacher;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherAward;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherDuty;
import yangtz.cs.liu.campus.mapper.teacher.SchoolTeacherAwardMapper;
import yangtz.cs.liu.campus.mapper.teacher.SchoolTeacherDutyMapper;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherAwardService;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherAwardVO;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

@Service
public class SchoolTeacherAwardServiceImpl extends ServiceImpl<SchoolTeacherAwardMapper, SchoolTeacherAward> implements ISchoolTeacherAwardService {

    @Autowired
    private SchoolTeacherAwardMapper schoolTeacherAwardMapper;

    /*
     * 查询教师获奖信息列表
     * */
    @Override
    public List<SchoolTeacherAward> selectSchoolTeacherAwardList(SchoolTeacherAwardVO schoolTeacherAwardVO) {
        return schoolTeacherAwardMapper.selectSchoolTeacherAwardList(schoolTeacherAwardVO);
    }

    /*
     * 新增老师获奖信息
     * */
    @Override
    public int insertSchoolTeacherAward(SchoolTeacherAward schoolTeacherAward) {
        return schoolTeacherAwardMapper.insertSchoolTeacherAward(schoolTeacherAward);
    }

    @Override
    public int updateSchoolTeacherAward(SchoolTeacherAward schoolTeacherAward) {
        return schoolTeacherAwardMapper.updateSchoolTeacherAward(schoolTeacherAward);
    }

    /*
     * 删除老师获奖信息byIds
     * */
    @Override
    public int deleteSchoolTeacherAwardByIds(List<Long> ids) {
        return schoolTeacherAwardMapper.deleteSchoolTeacherAwardByIds(ids);
    }

    /*
    * 根据id删除
    * */
    @Override
    public int deleteSchoolTeacherAwardById(List<Long> ids) {
        return schoolTeacherAwardMapper.deleteSchoolTeacherAwardById(ids);
    }

    @Override
    public List<SchoolTeacherAward> listByIds(List<Long> ids) {
        return schoolTeacherAwardMapper.listByIds(ids);
    }

    @Override
    public List<SchoolTeacherAward> queryList(SchoolTeacherAward schoolTeacherAward) {
        LambdaQueryWrapper<SchoolTeacherAward> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotNull(schoolTeacherAward.getTeacherId()), SchoolTeacherAward::getTeacherId, schoolTeacherAward.getTeacherId())
                .like(isNotBlank(schoolTeacherAward.getTeacherName()),SchoolTeacherAward::getTeacherName,schoolTeacherAward.getTeacherName())
                .like(isNotBlank(schoolTeacherAward.getAwardName()),SchoolTeacherAward::getAwardName,schoolTeacherAward.getAwardName())
                .eq(isNotBlank(schoolTeacherAward.getHonor()),SchoolTeacherAward::getHonor,schoolTeacherAward.getHonor())
                .apply(ObjectUtil.isNotNull(schoolTeacherAward.getParams().get("beginTime")),
                        "date_format(award_time,'%Y-%m-%d') >= date_format('" + schoolTeacherAward.getParams().get("beginTime") + "','%Y-%m-%d') ")
                .apply(ObjectUtil.isNotNull(schoolTeacherAward.getParams().get("endTime")),
                        "date_format(award_time,'%Y-%m-%d') <= date_format('" + schoolTeacherAward.getParams().get("endTime") + "','%Y-%m-%d') ")
                .orderByDesc(SchoolTeacherAward::getAwardTime)
        ;
        return schoolTeacherAwardMapper.selectList(lqw);
    }


}
