package yangtz.cs.liu.campus.service.impl.student;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.student.SchoolStudentEducational;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentEducationalMapper;
import yangtz.cs.liu.campus.service.student.ISchoolStudentEducationalService;


/**
 * 学生Service业务层处理
 *
 * @author hxz
 * @date 2023-02-26
 */
@Service
public class SchoolStudentEducationalServiceImpl extends ServiceImpl<SchoolStudentEducationalMapper,SchoolStudentEducational> implements ISchoolStudentEducationalService
{
    @Autowired
    private SchoolStudentEducationalMapper schoolStudentEducationalMapper;

    /**
     * 查询学生
     *
     * @param id 学生主键
     * @return 学生
     */
    @Override
    public SchoolStudentEducational selectSchoolStudentEducationalById(Long id)
    {
        return schoolStudentEducationalMapper.selectSchoolStudentEducationalById(id);
    }

    /**
     * 查询学生列表
     *
     * @param schoolStudentEducational 学生
     * @return 学生
     */
    @Override
    public List<SchoolStudentEducational> selectSchoolStudentEducationalList(SchoolStudentEducational schoolStudentEducational)
    {
        return schoolStudentEducationalMapper.selectSchoolStudentEducationalList(schoolStudentEducational);
    }

    /**
     * 新增学生
     *
     * @param schoolStudentEducational 学生
     * @return 结果
     */
    @Override
    public int insertSchoolStudentEducational(SchoolStudentEducational schoolStudentEducational)
    {
        schoolStudentEducational.setCreateTime(DateUtils.getNowDate());
        return schoolStudentEducationalMapper.insertSchoolStudentEducational(schoolStudentEducational);
    }

    /**
     * 修改学生
     *
     * @param schoolStudentEducational 学生
     * @return 结果
     */
    @Override
    public int updateSchoolStudentEducational(SchoolStudentEducational schoolStudentEducational)
    {
        schoolStudentEducational.setUpdateTime(DateUtils.getNowDate());
        return schoolStudentEducationalMapper.updateSchoolStudentEducational(schoolStudentEducational);
    }

    /**
     * 批量删除学生
     *
     * @param ids 需要删除的学生主键
     * @return 结果
     */
    @Override
    public int deleteSchoolStudentEducationalByIds(Long[] ids)
    {
        return schoolStudentEducationalMapper.deleteSchoolStudentEducationalByIds(ids);
    }

    /**
     * 删除学生信息
     *
     * @param id 学生主键
     * @return 结果
     */
    @Override
    public int deleteSchoolStudentEducationalById(Long id)
    {
        return schoolStudentEducationalMapper.deleteSchoolStudentEducationalById(id);
    }
}
