package yangtz.cs.liu.campus.service.impl.schoolgrade;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGradeMentor;
import yangtz.cs.liu.campus.mapper.schoolgrade.SchoolGradeMentorMapper;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeMentorService;
import yangtz.cs.liu.campus.vo.schoolgrade.SchoolGradeMentorVo;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherVO;

import java.util.List;

@Service
public class ISchoolGradeMentorImpl extends ServiceImpl<SchoolGradeMentorMapper, SchoolGradeMentor> implements ISchoolGradeMentorService {

    @Autowired
    private SchoolGradeMentorMapper schoolGradeMentorMapper;

    /**
     * 查询方法
     *
     * @param schoolGradeMentor
     * @return
     */
    @Override
    public List<SchoolGradeMentorVo> selectSchoolGradeMentorList(SchoolGradeMentorVo schoolGradeMentor) {
        List<SchoolGradeMentorVo> list = schoolGradeMentorMapper.selectSchoolGrade(schoolGradeMentor);
        return list;
    }

    @Override
    public SchoolGradeMentorVo selectSchoolGradeMentorById(Long id) {
        SchoolGradeMentorVo schoolGradeMentorVo = schoolGradeMentorMapper.selectSchoolGradeById(id);
        return schoolGradeMentorVo;
    }

    /**
     * 得到老师名字
     *
     * @param schoolGradeMentor
     * @return
     */
    @Override
    public String selectTeacherName(SchoolGradeMentor schoolGradeMentor) {
        String teachername = schoolGradeMentorMapper.selectByTeacherName(schoolGradeMentor.getTeacherId());

        return teachername;
    }

    @Override
    public SchoolGradeMentor selectSchoolGradeById(Long id) {
        LambdaQueryWrapper<SchoolGradeMentor> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolGradeMentor::getId, id);
        SchoolGradeMentor schoolGradeMentor = schoolGradeMentorMapper.selectOne(lqw);
        return schoolGradeMentor;
    }


    @Override
    public List<SchoolGradeMentorVo> exportByIds(List<Integer> ids,Long gradeId) {
        return schoolGradeMentorMapper.exportByIds(ids,gradeId);
    }


    @Override
    public List<SchoolTeacher> getGradeLeader(Long gradeId, String role, SchoolTeacherVO teacherVO) {
        return schoolGradeMentorMapper.getGradeLeader(gradeId,role,teacherVO);
    }

    @Override
    public List<SchoolGrade> selectGradeList(Long userId) {
        return schoolGradeMentorMapper.getGrades(userId);
    }

    /**获取用户所在级部列表*/
    @Override
    public List<SchoolGrade> selectGrades(Long userId,int schoolYear) {
        return schoolGradeMentorMapper.getGradeByUserId(userId,schoolYear);
    }
}

