package yangtz.cs.liu.campus.service.impl.schoolcalendar;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolcalendar.SchoolCalendar;
import yangtz.cs.liu.campus.mapper.schoolcalendar.SchoolCalendarMapper;
import yangtz.cs.liu.campus.service.schoolcalendar.ISchoolCalendarService;
import yangtz.cs.liu.campus.vo.schoolcalendar.SchoolCalendarVo;


import java.util.Date;
import java.util.List;

import static com.ruoyi.common.utils.StringUtils.isNotNull;


@Service
public class ISchoolCalendarImpl extends ServiceImpl<SchoolCalendarMapper, SchoolCalendar> implements ISchoolCalendarService {


    @Autowired
    private SchoolCalendarMapper schoolCalendarMapper;

    /**
     * 查询校历
     *
     * @param schoolCalendar
     * @return
     */
    public List<SchoolCalendarVo> selectSchoolCalendarList(SchoolCalendar schoolCalendar) {
        return schoolCalendarMapper.select(schoolCalendar);
    }

    /**
     * 修改校历
     *
     * @param schoolCalendar 校历
     * @return 结果
     */
    @Override
    public int updateSchoolCalendar(SchoolCalendar schoolCalendar) {
        schoolCalendar.setUpdateTime(DateUtils.getNowDate());
        return schoolCalendarMapper.updateById(schoolCalendar);
    }


    /**
     * 下拉框
     *
     * @param schoolCalendar
     * @return
     */
    @Override
    public List<SchoolCalendar> selectSchoolCalendarForSelecter(SchoolCalendar schoolCalendar) {
        LambdaQueryWrapper<SchoolCalendar> lqw = new LambdaQueryWrapper<>();
        lqw.select(SchoolCalendar::getCalendarName);
        return schoolCalendarMapper.selectList(lqw);
    }


    /**
     * 公众号：获取当前时间所在的校历
     * @param date
     * @return
     */
    @Override
    public SchoolCalendar getNowCalendar(Date date) {
        List<SchoolCalendar> list = schoolCalendarMapper.getNowCalendar(date);
        if(StringUtils.isNull(list) || list.size() == 0){
            return new SchoolCalendar();
        }
        return list.get(0);
    }
}
