package yangtz.cs.liu.campus.service.impl.schoolcalendar;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.core.utils.HolidayDateUtil;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolcalendar.SchoolCalendar;
import yangtz.cs.liu.campus.domain.schoolcalendar.SchoolCalendarDetail;
import yangtz.cs.liu.campus.mapper.schoolcalendar.SchoolCalendarDetailMapper;
import yangtz.cs.liu.campus.mapper.schoolcalendar.SchoolCalendarMapper;
import yangtz.cs.liu.campus.service.schoolcalendar.ISchoolCalendarDetailService;
import yangtz.cs.liu.campus.vo.schoolcalendar.SchoolCalendarDetailVo;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.collectingAndThen;
import static java.util.stream.Collectors.toCollection;


@Service
public class ISchoolCalendarDetailImpl extends ServiceImpl<SchoolCalendarDetailMapper, SchoolCalendarDetail> implements ISchoolCalendarDetailService {

    @Autowired
    private SchoolCalendarDetailMapper schoolCalendarDetailMapper;

    @Autowired
    private SchoolCalendarMapper schoolCalendarMapper;

    //校历
    public static final String SCHOOLTYPE = "1";
    public static final String STATUS = "0";

    @Override
    public List<SchoolCalendarDetailVo> selectSchoolCalendarDetailList(SchoolCalendarDetail schoolCalendarDetail) {
        return schoolCalendarDetailMapper.selectSchoolCalendarDetailList(schoolCalendarDetail);
    }

    @Override
    public SchoolCalendarDetailVo getQueryOne(Long id) {
        return schoolCalendarDetailMapper.getQueryOne(id);
    }

    @Override
    public int updateSchoolCalendarDetail(SchoolCalendarDetail schoolCalendarDetail) {


        return schoolCalendarDetailMapper.updateById(schoolCalendarDetail);
    }


    @Override
    public int insertSchoolCalendarDetail(SchoolCalendarDetail schoolCalendarDetail) {


        return schoolCalendarDetailMapper.insert(schoolCalendarDetail);
    }

    @Override
    public List<SchoolCalendarDetail> selectThings(Date date) {
        //获取当前时间所在校历
        List<SchoolCalendar> scList = schoolCalendarMapper.getNowCalendarList(date);
        if(StringUtils.isNull(scList) || scList.size() == 0){
            return new ArrayList<>();
        }
        //查询当前日期所在范围的详细条目
        List<SchoolCalendarDetail> list = new ArrayList<>();
        for(SchoolCalendar sc : scList){
            List<SchoolCalendarDetail> details = schoolCalendarDetailMapper.getCalendar(date,sc.getId());
            list.addAll(details);
        }
        if(StringUtils.isNull(list) || list.size() == 0){
            return new ArrayList<>();
        }
        return list;
    }

    @Override
    public List<SchoolCalendarDetail> selectAllYear(Date date) {
        /*LambdaQueryWrapper<SchoolCalendarDetail> lqw = new LambdaQueryWrapper<>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);   //设置当前时间
        cal.add(Calendar.YEAR, 1);
        lqw
                .ge(SchoolCalendarDetail::getStartTime,date)
                .le(SchoolCalendarDetail::getEndTime,cal.getTime())
                ;*/
        //获取传入data的所在年，获取所在年的最后一天
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dateYear = calendar.get(Calendar.YEAR);
        calendar.clear();
        calendar.set(Calendar.YEAR, dateYear);
        calendar.roll(Calendar.DAY_OF_YEAR, -1);
        Date endDate = calendar.getTime();
        return schoolCalendarDetailMapper.getThing(date,endDate,STATUS);
    }


    /**
     * 公众号查询当前日期所在的校历详细条目
     * @param
     * @return
     */
    @Override
    public List<SchoolCalendarDetail> getCalendar(Date date,Long calendarId) {
        return schoolCalendarDetailMapper.getCalendar(date,calendarId);
    }

    /**
     * 获取当前月份所有节假日
     * @param calendarId
     * @param start
     * @param end
     * @return
     */
    @Override
    public List<SchoolCalendarDetail> getMonth(Long calendarId, Date start, Date end) {
        //获取正在运行的校历
        LambdaQueryWrapper<SchoolCalendar> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolCalendar::getStatus,STATUS);
        List<SchoolCalendar> list = schoolCalendarMapper.selectList(lqw);
        if(StringUtils.isNull(list) || list.size() == 0){
            return new ArrayList<>();
        }
        //获取校历id并去重
        List<Long> idList = list.stream().map(SchoolCalendar::getId).distinct().collect(Collectors.toList());
        //获取传入起至日期的所有日期
        List<Date> dayList = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        while(calendar.getTime().before(end)){
            dayList.add(calendar.getTime());
            calendar.add(Calendar.DAY_OF_MONTH, 1);
        }
        dayList.add(end);
        //获取每一日期在内的校历事件
        List<SchoolCalendarDetail> details = new ArrayList<>();
        for(Date d : dayList){
            List l = schoolCalendarDetailMapper.getMonthDay(idList,d);
            if(StringUtils.isNotNull(l) && l.size() > 0){
                details.addAll(l);
            }
        }
        //如果事件不为空，则根据id去重
        if(StringUtils.isNotNull(details) && details.size() > 0){
            details = details.stream().collect(
                    collectingAndThen(
                            toCollection(() -> new TreeSet<>(Comparator.comparing(SchoolCalendarDetail::getId))), ArrayList::new));
        }
        return details;
    }

}
