package yangtz.cs.liu.campus.service.impl.schoolEquipment;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.annotation.DataScope;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolReceive;
import yangtz.cs.liu.campus.mapper.schoolEquipment.ReceiveMapper;
import yangtz.cs.liu.campus.service.schoolEquipment.IReceiveService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolReceiveVo;

import java.util.List;

@Service
public class ReceiveServiceImpl extends ServiceImpl<ReceiveMapper, SchoolReceive> implements IReceiveService {

    @Autowired
    private ReceiveMapper receiveMapper;
    @Autowired
    private SysUserMapper sysUserMapper;

    /**
     * 查看设备领用列表
     * @param schoolReceiveVo
     * @return
     */
    @Override
    @DataScope(userAlias = "u")
    public List<SchoolReceiveVo> selectSchoolReceiveVoList(SchoolReceiveVo schoolReceiveVo) {
        return receiveMapper.selectSchoolReceiveVoList(schoolReceiveVo);
    }

    /**
     * 查看设备领用详细信息
     * @param id
     * @return
     */
    @Override
    public SchoolReceiveVo selectSchoolReceiveVoById(Long id) {
        return receiveMapper.selectSchoolReceiveVoById(id);
    }

    /**
     * 新增设备领用
     * @param schoolReceive
     * @return
     */
    @Override
    public int insertSchoolReceive(SchoolReceive schoolReceive) {
        if (StringUtils.isNotNull(schoolReceive.getRecipientById())){
            String userName = sysUserMapper.selectUserById(schoolReceive.getRecipientById()).getUserName();
            schoolReceive.setRecipientBy(userName);
        }
        if (StringUtils.isNotNull(schoolReceive.getReceivedById())){
            String userName = sysUserMapper.selectUserById(schoolReceive.getReceivedById()).getUserName();
            schoolReceive.setReceivedBy(userName);
        }
        schoolReceive.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolReceive.setCreateTime(DateUtils.getNowDate());
        return receiveMapper.insert(schoolReceive);
    }

    /**
     * 修改设备领用
     * @param schoolReceive
     * @return
     */
    @Override
    public int updateSchoolReceive(SchoolReceive schoolReceive) {
        if (StringUtils.isNotNull(schoolReceive.getRecipientById())){
            String userName = sysUserMapper.selectUserById(schoolReceive.getRecipientById()).getUserName();
            schoolReceive.setRecipientBy(userName);
        }
        if (StringUtils.isNotNull(schoolReceive.getReceivedById())){
            String userName = sysUserMapper.selectUserById(schoolReceive.getReceivedById()).getUserName();
            schoolReceive.setReceivedBy(userName);
        }
        schoolReceive.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolReceive.setUpdateTime(DateUtils.getNowDate());
        return receiveMapper.updateById(schoolReceive);
    }

    /**
     * 删除设备领用
     * @param ids
     * @return
     */
    @Override
    public int deleteSchoolReceiveByIds(Long[] ids) {
        return receiveMapper.deleteSchoolReceiveByIds(ids);
    }
}
