package yangtz.cs.liu.campus.service.impl.schoolEquipment;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.annotation.DataScope;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.system.mapper.SysUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolProductCategory;
import yangtz.cs.liu.campus.mapper.schoolEquipment.ProductCategoryMapper;
import yangtz.cs.liu.campus.service.schoolEquipment.IProductCategoryService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolProductCategoryVo;

import java.util.List;
import java.util.Map;

@Service
public class ProductCategoryServiceImpl extends ServiceImpl<ProductCategoryMapper, SchoolProductCategory> implements IProductCategoryService {

    @Autowired
    private ProductCategoryMapper productCategoryMapper;
    @Autowired
    private SysUserMapper sysUserMapper;

    /**
     * 查看产品分类列表
     * @param schoolProductCategory
     * @return
     */
    @Override
    @DataScope(userAlias = "u")
    public List<SchoolProductCategory> selectSchoolProductCateGory(SchoolProductCategory schoolProductCategory) {
        return productCategoryMapper.selectSchoolProductCateGory(schoolProductCategory);
    }

    /**
     * 查看产品分类详细信息
     * @param id
     * @return
     */
    @Override
    public SchoolProductCategoryVo selectSchoolProductCateGoryById(Long id) {
        return productCategoryMapper.selectSchoolProductCateGoryById(id);
    }

    /**
     * 新增产品分类
     * @param schoolProductCategory
     * @return
     */
    @Override
    @Transactional
    public int insertSchoolProductCategory(SchoolProductCategory schoolProductCategory) {
        //查询分类编码是否重复
        LambdaQueryWrapper<SchoolProductCategory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolProductCategory::getClassificationCode,schoolProductCategory.getClassificationCode())
                .eq(SchoolProductCategory::getDelFlag,"0");
        List<SchoolProductCategory> schoolProductCategories = productCategoryMapper.selectList(wrapper);
        if (schoolProductCategories != null && schoolProductCategories.size() > 0){
            throw new ServiceException("该分类编码已存在");
        }
        //父id
        Long parentId = schoolProductCategory.getParentId();
        if (null != parentId){
            SchoolProductCategory schoolProductCategory1 = productCategoryMapper.selectById(parentId);
            schoolProductCategory.setAncestors(schoolProductCategory1.getAncestors() + "," + parentId);
        }else {
            schoolProductCategory.setParentId((long) 0);
            schoolProductCategory.setAncestors("0");
        }
        String[] split = schoolProductCategory.getAncestors().split(",");
        schoolProductCategory.setRank((long) split.length);
        String userName = sysUserMapper.selectUserById(schoolProductCategory.getAdminId()).getUserName();
        schoolProductCategory.setAdmin(userName);
        schoolProductCategory.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolProductCategory.setCreateTime(DateUtils.getNowDate());
        return productCategoryMapper.insert(schoolProductCategory);
    }

    /**
     * 修改产品分类信息
     * @param schoolProductCategory
     * @return
     */
    @Override
    @Transactional
    public int updateSchoolProductCategory(SchoolProductCategory schoolProductCategory) {
        //根据用户id获取用户名
        String userName = sysUserMapper.selectUserById(schoolProductCategory.getAdminId()).getUserName();
        schoolProductCategory.setAdmin(userName);
        schoolProductCategory.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolProductCategory.setUpdateTime(DateUtils.getNowDate());
        return productCategoryMapper.updateById(schoolProductCategory);
    }

    /**
     * 删除产品分类信息
     * @param ids
     * @return
     */
    @Override
    @Transactional
    public int deleteSchoolProductCategory(Long[] ids) {
        int i = 0;
        for (Long id : ids) {
            i += productCategoryMapper.deleteSchoolProductCategory(id);
        }
        return i;
    }

    /**
     * 获取设备分类下拉框
     * @param
     * @return
     */
    @Override
    @DataScope(userAlias = "u")
    public List<Map<String, String>> getEquipmentType(SchoolProductCategory schoolProductCategory) {
        return productCategoryMapper.getEquipmentType(schoolProductCategory);
    }

    /**
     * 获取管理员
     * @return
     */
    @Override
    @DataScope(userAlias = "u")
    public List<Map<String, String>> getAdmin(SchoolProductCategory schoolProductCategory) {
        return productCategoryMapper.getAdmin(schoolProductCategory);
    }

    /**
     * 根据分类编码查询产品分类信息
     * @param code
     * @return
     */
    @Override
    public SchoolProductCategory getEquipmentByCode(String code) {
        LambdaQueryWrapper<SchoolProductCategory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolProductCategory::getClassificationCode,code);
        return productCategoryMapper.selectOne(wrapper);
    }
}
