package yangtz.cs.liu.campus.service.impl.schoolEquipment;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.annotation.DataScope;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysUserMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolEquipmentRepair;
import yangtz.cs.liu.campus.mapper.schoolEquipment.EquipmentRepairMapper;
import yangtz.cs.liu.campus.service.schoolEquipment.IEquipmentRepairService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolEquipmentRepairVo;

import java.util.List;
import java.util.Map;

@Service
public class EquipmentRepairServiceImpl extends ServiceImpl<EquipmentRepairMapper, SchoolEquipmentRepair> implements IEquipmentRepairService {


    @Autowired
    private EquipmentRepairMapper equipmentRepairMapper;
    @Autowired
    private SysUserMapper sysUserMapper;

    /**
     * 查看设备报修列表
     * @param schoolEquipmentRepairVo
     * @return
     */
    @Override
    @DataScope(userAlias = "u")
    public List<SchoolEquipmentRepairVo> selectSchoolEquipmentRepairVoList(SchoolEquipmentRepairVo schoolEquipmentRepairVo) {
        return equipmentRepairMapper.selectSchoolEquipmentRepairVoList(schoolEquipmentRepairVo);
    }

    /**
     * 查看设备报修详细信息
     * @param id
     * @return
     */
    @Override
    public SchoolEquipmentRepairVo selectSchoolEquipmentRepairVoById(Long id) {
        return equipmentRepairMapper.selectSchoolEquipmentRepairVoById(id);
    }

    /**
     * 新增设备报修
     * @return
     */
    @Override
    @Transactional
    public int insertSchoolEquipmentRepairVo(SchoolEquipmentRepair schoolEquipmentRepair) {
        if (StringUtils.isNotNull(schoolEquipmentRepair.getReportRepairId())){
            String userName = sysUserMapper.selectUserById(schoolEquipmentRepair.getReportRepairId()).getUserName();
            schoolEquipmentRepair.setReportRepair(userName);
        }
        if (StringUtils.isNotNull(schoolEquipmentRepair.getRepairId())){
            String userName = sysUserMapper.selectUserById(schoolEquipmentRepair.getRepairId()).getUserName();
            schoolEquipmentRepair.setRepairName(userName);
        }
        schoolEquipmentRepair.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolEquipmentRepair.setCreateTime(DateUtils.getNowDate());
        return equipmentRepairMapper.insert(schoolEquipmentRepair);
    }

    /**
     * 修改设备报修
     * @param schoolEquipmentRepair
     * @return
     */
    @Override
    @Transactional
    public int updateSchoolEquipmentRepair(SchoolEquipmentRepair schoolEquipmentRepair) {
        if (StringUtils.isNotNull(schoolEquipmentRepair.getReportRepairId())){
            String userName = sysUserMapper.selectUserById(schoolEquipmentRepair.getReportRepairId()).getUserName();
            schoolEquipmentRepair.setReportRepair(userName);
        }
        if (StringUtils.isNotNull(schoolEquipmentRepair.getRepairId())){
            String userName = sysUserMapper.selectUserById(schoolEquipmentRepair.getRepairId()).getUserName();
            schoolEquipmentRepair.setRepairName(userName);
        }
        schoolEquipmentRepair.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolEquipmentRepair.setUpdateTime(DateUtils.getNowDate());
        return equipmentRepairMapper.updateById(schoolEquipmentRepair);
    }

    /**
     * 删除设备报修
     * @param ids
     * @return
     */
    @Override
    @Transactional
    public int deleteSchoolEquipmentRepairById(Long[] ids) {
        return equipmentRepairMapper.deleteSchoolEquipmentRepairById(ids);
    }

    /**
     * 根据自编码获取设备信息
     * @param encode
     * @return
     */
    @Override
    public Map<String, String> getEquipment(String encode) {
//        Long userId = SecurityUtils.getLoginUser().getUser().getUserId();
        return equipmentRepairMapper.getEquipment(encode);
    }

    /**
     * 获取修理人下拉框
     * @return
     */
    @Override
    public List<Map<String, String>> getRepair() {
        return equipmentRepairMapper.getRepair();
    }

  @Override
  public SchoolEquipmentRepairVo getEquipmentById(Long id) {
    return equipmentRepairMapper.getEquipmentById(id);
  }

  @Override
  public List<SchoolEquipmentRepairVo> getMaintenanceList(Long reportRepairid) {
    return equipmentRepairMapper.getMaintenanceList(reportRepairid);
  }

  /**
   * 管理员获取所有维修列表
   * @return
   */
  @Override
  public List<SchoolEquipmentRepairVo> getlist() {
    return equipmentRepairMapper.getlist();
  }

  @Override
  public List<SchoolEquipmentRepairVo> getMaintenanceUserList() {
    return equipmentRepairMapper.getMaintenanceUserList();
  }

}
