package yangtz.cs.liu.campus.service.impl.schoolEquipment;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.annotation.DataScope;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolCirculation;
import yangtz.cs.liu.campus.mapper.schoolEquipment.CirculationMapper;
import yangtz.cs.liu.campus.service.schoolEquipment.ICirculationService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolCirculationVo;

import java.util.List;

@Service
public class CirculationServiceImpl extends ServiceImpl<CirculationMapper, SchoolCirculation> implements ICirculationService {


  @Autowired
  private CirculationMapper circulationMapper;
  @Autowired
  private SysUserMapper sysUserMapper;

  @Override
  public List<SchoolCirculationVo> getReturningEquipmentByadminId(Long userId) {
    return circulationMapper.getReturningEquipmentByadminId(userId);
  }

  @Override
  public SchoolCirculationVo getSchoolCirculationVoById(Long id) {
    return circulationMapper.getSchoolCirculationVoById(id);
  }


    /**
     * 查看设备借出归还列表
     * @param schoolCirculationVo
     * @return
     */
    @Override
    @DataScope(userAlias = "u")
    public List<SchoolCirculationVo> selectSchoolCirculationVoList(SchoolCirculationVo schoolCirculationVo) {
        return circulationMapper.selectSchoolCirculationVoList(schoolCirculationVo);
    }

    /**
     * 查看设备借出归还详细信息
     * @param id
     * @return
     */
    @Override
    public SchoolCirculationVo selectSchoolCirculationVoById(Long id) {
        return circulationMapper.selectSchoolCirculationVoById(id);
    }

    /**
     * 新增设备借出归还信息
     * @param schoolCirculation
     * @return
     */
    @Override
    @Transactional
    public int insertSchoolCirculation(SchoolCirculation schoolCirculation) {
        if (StringUtils.isNotNull(schoolCirculation.getBorrowById())){
          String userName = sysUserMapper.selectUserById(schoolCirculation.getBorrowById()).getUserName();
          schoolCirculation.setBorrowBy(userName);
        }
        if (StringUtils.isNotNull(schoolCirculation.getReceivedById())){
          String userName = sysUserMapper.selectUserById(schoolCirculation.getReceivedById()).getUserName();
          schoolCirculation.setReceivedBy(userName);
        }
        schoolCirculation.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolCirculation.setCreateTime(DateUtils.getNowDate());
        return circulationMapper.insert(schoolCirculation);

    }

    /**
     * 修改设备借出归还信息
     * @param schoolCirculation
     * @return
     */
    @Override
    public int updateSchoolCirculation(SchoolCirculation schoolCirculation) {
        if (StringUtils.isNotNull(schoolCirculation.getBorrowById())){
          String userName = sysUserMapper.selectUserById(schoolCirculation.getBorrowById()).getUserName();
          schoolCirculation.setBorrowBy(userName);
        }
        if (StringUtils.isNotNull(schoolCirculation.getReceivedById())){
          String userName = sysUserMapper.selectUserById(schoolCirculation.getReceivedById()).getUserName();
          schoolCirculation.setReceivedBy(userName);
        }
        schoolCirculation.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolCirculation.setUpdateTime(DateUtils.getNowDate());
        return circulationMapper.updateById(schoolCirculation);
    }

    /**
     * 删除设备借出归还信息
     * @param ids
     * @return
     */
    @Override
    public int deleteSchoolCirculationByIds(Long[] ids) {
        return circulationMapper.deleteSchoolCirculationByIds(ids);
    }

}
