package yangtz.cs.liu.campus.service.impl.schoolDuty;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.List;

import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.common.utils.StringUtils;
import yangtz.cs.liu.campus.domain.schoolDuty.SchoolDuty;
import yangtz.cs.liu.campus.mapper.schoolDuty.SchoolDutyDetailsMapper;
import yangtz.cs.liu.campus.mapper.schoolDuty.SchoolDutyMapper;
import yangtz.cs.liu.campus.service.schoolDuty.ISchoolDutyService;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static org.apache.logging.log4j.util.Strings.isNotBlank;

/**
 * 值班管理Service业务层处理
 *
 */
@Service
public class SchoolDutyServiceImpl extends ServiceImpl<SchoolDutyMapper, SchoolDuty> implements ISchoolDutyService
{
    @Autowired
    private SchoolDutyMapper schoolDutyMapper;

    /**
     * 查询值班管理列表
     *
     * @param schoolDuty 值班管理
     * @return 值班管理
     */

    @Override
    public List<SchoolDuty> selectSchoolDutyList(SchoolDuty schoolDuty)
    {
        return schoolDutyMapper.selectSchoolDutyList(schoolDuty);
    }

    /**
     * 查询值班管理列表-节日
     *
     * @param schoolDuty 值班管理
     * @return 值班管理
     */
    @Override
    public List<SchoolDuty> queryList(SchoolDuty schoolDuty) {
        LambdaQueryWrapper<SchoolDuty> lqw = new LambdaQueryWrapper<>();
        lqw.eq(isNotBlank(schoolDuty.getDutyType()),SchoolDuty::getDutyType,schoolDuty.getDutyType());
        List<SchoolDuty> schoolDuties = schoolDutyMapper.selectList(lqw);
        return schoolDuties;
    }

    @Override
    public int updateSchoolDuty(SchoolDuty schoolDuty) {
        schoolDuty.setUpdateTime(DateUtils.getNowDate());
        return schoolDutyMapper.updateSchoolDuty(schoolDuty);
    }

    @Override
    public Boolean checkIsExist(SchoolDuty schoolDuty) {

        LambdaQueryWrapper<SchoolDuty> name = new LambdaQueryWrapper<>();
        name.eq(SchoolDuty::getDutyName,schoolDuty.getDutyName());

        SchoolDuty dutyNum = schoolDutyMapper.selectOne(name);

        if (StringUtils.isNotNull(dutyNum)){
            return true;
        }
        return false;
    }

    @Override
    public void importSchoolBudgetVoList(List<SchoolDuty> list) {
        LambdaQueryWrapper<SchoolDuty> lqw = new LambdaQueryWrapper<>();
        for (SchoolDuty schoolDuty:list) {
            lqw.eq(SchoolDuty::getDutyName,schoolDuty.getDutyName());
            SchoolDuty duty = schoolDutyMapper.selectOne(lqw);
            if (StringUtils.isNull(duty)){
                schoolDutyMapper.insert(schoolDuty);
            }
        }
    }
}
