package yangtz.cs.liu.campus.service.impl.message;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.message.SchoolMessageParentsPushs;
import yangtz.cs.liu.campus.domain.message.SchoolMessageParentsPushsDetails;
import yangtz.cs.liu.campus.domain.message.SchoolMessagePush;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.mapper.message.SchoolMessageParentsPushsDetailsMapper;
import yangtz.cs.liu.campus.mapper.message.SchoolMessageParentsPushsMapper;
import yangtz.cs.liu.campus.service.message.ISchoolMessageParentsPushsService;
import yangtz.cs.liu.wechat.vo.message.ParentPushVO;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 家长端消息推送Service业务层处理
 *
 * @author ruoyi
 * @date 2022-10-28
 */
@Service
public class SchoolMessageParentsPushsServiceImpl extends ServiceImpl<SchoolMessageParentsPushsMapper, SchoolMessageParentsPushs> implements ISchoolMessageParentsPushsService {
    @Autowired
    private SchoolMessageParentsPushsMapper schoolMessageParentsPushsMapper;
    @Autowired
    private SchoolMessageParentsPushsDetailsMapper parentsPushsDetailsMapper;
    @Autowired
    UserInfoUtil userInfoUtil;


    @Override
    public List<SchoolMessageParentsPushs> queryList(SchoolMessageParentsPushs schoolMessageParentsPushs) {
        LambdaQueryWrapper<SchoolMessageParentsPushs> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(schoolMessageParentsPushs.getTitle()), SchoolMessageParentsPushs::getTitle, schoolMessageParentsPushs.getTitle())
                .eq(isNotBlank(schoolMessageParentsPushs.getState()),SchoolMessageParentsPushs::getState,schoolMessageParentsPushs.getState())
                .orderByDesc(SchoolMessageParentsPushs::getCreateTime)
        ;
        return schoolMessageParentsPushsMapper.selectList(lqw);
    }

    @Override
    public List<Long> queryDetailsList(List<Long> list) {
        LambdaQueryWrapper<SchoolMessageParentsPushsDetails> lqw = new LambdaQueryWrapper<>();
        lqw.in(SchoolMessageParentsPushsDetails::getUserId,list);
        List<SchoolMessageParentsPushsDetails> details = parentsPushsDetailsMapper.selectList(lqw);
        if(StringUtils.isNull(details) || details.size() == 0){
            return new ArrayList<>();
        }
        //获取家长信息推送id并排重
        List<Long> idList = details.stream().map(SchoolMessageParentsPushsDetails::getPushId).distinct().collect(Collectors.toList());
        return idList;
    }

    @Override
    public List<SchoolMessageParentsPushs> queryGradeList(List<Long> list,SchoolMessageParentsPushs schoolMessageParentsPushs) {
        LambdaQueryWrapper<SchoolMessageParentsPushs> lqw = new LambdaQueryWrapper<>();
        lqw
                .in(SchoolMessageParentsPushs::getId,list)
                .like(isNotBlank(schoolMessageParentsPushs.getTitle()), SchoolMessageParentsPushs::getTitle, schoolMessageParentsPushs.getTitle())
                .eq(isNotBlank(schoolMessageParentsPushs.getState()),SchoolMessageParentsPushs::getState,schoolMessageParentsPushs.getState())
                .orderByDesc(SchoolMessageParentsPushs::getCreateTime)
        ;
        return schoolMessageParentsPushsMapper.selectList(lqw);
    }

    //删除家长消息
    @Override
    public int deletePushList(List<Long> ids) {
        //删除子表
        LambdaQueryWrapper<SchoolMessageParentsPushsDetails> lqw = new LambdaQueryWrapper<>();
        lqw.in(SchoolMessageParentsPushsDetails::getPushId,ids);
        parentsPushsDetailsMapper.delete(lqw);
        return schoolMessageParentsPushsMapper.deleteBatchIds(ids);
    }

    /**
     * 查询微信家长消息列表
     *
     * @param pushVO
     * @return
     */
    @Override
    public List<ParentPushVO> parentPushList(Long userId, ParentPushVO pushVO) {
        List<ParentPushVO> list = schoolMessageParentsPushsMapper.getList(userId,pushVO);
        return list;
    }
}
