package yangtz.cs.liu.campus.service.impl.interest;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.bean.BeanUtils;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClasses;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesAttendance;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesChild;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesDetails;
import yangtz.cs.liu.campus.mapper.interest.SchoolInterestClassesAttendanceMapper;
import yangtz.cs.liu.campus.mapper.interest.SchoolInterestClassesChildMapper;
import yangtz.cs.liu.campus.mapper.interest.SchoolInterestClassesDetailsMapper;
import yangtz.cs.liu.campus.mapper.interest.SchoolInterestClassesMapper;
import yangtz.cs.liu.campus.service.interest.ISchoolInterestClassesService;
import yangtz.cs.liu.wechat.vo.interest.ClassInfoVO;
import yangtz.cs.liu.wechat.vo.interest.ClassVO;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 兴趣班Service业务层处理
 *
 * @author ruoyi
 * @date 2022-10-04
 */
@Service
public class SchoolInterestClassesServiceImpl extends ServiceImpl<SchoolInterestClassesMapper, SchoolInterestClasses> implements ISchoolInterestClassesService {
    @Autowired
    private SchoolInterestClassesMapper schoolInterestClassesMapper;
    @Autowired
    private SchoolInterestClassesAttendanceMapper attendanceMapper;
    @Autowired
    private SchoolInterestClassesChildMapper childMapper;
    @Autowired
    private SchoolInterestClassesDetailsMapper detailsMapper;
    @Autowired
    UserInfoUtil userInfoUtil;
    //未报名
    public static final String NOJOIN = "0";
    //报名
    public static final String JOIN = "1";


    /**
     * 查询兴趣班列表
     *
     * @param schoolInterestClasses 兴趣班
     * @return 兴趣班
     */
    @Override
    public List<SchoolInterestClasses> queryList(SchoolInterestClasses schoolInterestClasses) {
        LambdaQueryWrapper<SchoolInterestClasses> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(schoolInterestClasses.getCurriculum()), SchoolInterestClasses::getCurriculum, schoolInterestClasses.getCurriculum())
                .like(isNotBlank(schoolInterestClasses.getTeacherName()), SchoolInterestClasses::getTeacherName, schoolInterestClasses.getTeacherName())
                .eq(isNotNull(schoolInterestClasses.getTeacherId()), SchoolInterestClasses::getTeacherId, schoolInterestClasses.getTeacherId())
                .orderByDesc(SchoolInterestClasses::getCreateTime)
        ;
        return schoolInterestClassesMapper.selectList(lqw);
    }

    @Override
    public int deleteList(List<Long> ids) {
        //删除详情
        LambdaQueryWrapper<SchoolInterestClassesDetails> detail = new LambdaQueryWrapper<>();
        detail
                .in(SchoolInterestClassesDetails::getInterestClassesId, ids)
        ;
        detailsMapper.delete(detail);
        //删除考勤
        LambdaQueryWrapper<SchoolInterestClassesAttendance> attendance = new LambdaQueryWrapper<>();
        attendance
                .in(SchoolInterestClassesAttendance::getInterestClassesId, ids)
        ;
        attendanceMapper.delete(attendance);
        //删除学生
        LambdaQueryWrapper<SchoolInterestClassesChild> child = new LambdaQueryWrapper<>();
        child
                .in(SchoolInterestClassesChild::getInterestClassesId, ids)
        ;
        childMapper.delete(child);
        return schoolInterestClassesMapper.deleteBatchIds(ids);
    }

    /**
     * 微信家长端兴趣班列表
     */
    @Override
    public List<ClassVO> queryAllClassesList(SchoolInterestClasses schoolInterestClasses) {
        return schoolInterestClassesMapper.queryAllClassesList(schoolInterestClasses);
    }

    /**
     * 微信教师端兴趣班列表
     */
    @Override
    public List<ClassVO> queryTeacherClassesList(ClassVO classVO) {
        //获取教师Id
        Long teacherId = userInfoUtil.getTeacherId();
        List<ClassVO> classesList = schoolInterestClassesMapper.queryTeacherClassesList(teacherId);
        return classesList;
    }

    //详情
    @Override
    public ClassInfoVO getInfoById(Long id) {
        SchoolInterestClasses classes = schoolInterestClassesMapper.selectById(id);
        ClassInfoVO classInfoVO = new ClassInfoVO();
        //获取当前学生id
        Long studentId = userInfoUtil.getStudentId();
        //查询当前学生是否参加该兴趣班
        LambdaQueryWrapper<SchoolInterestClassesChild> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolInterestClassesChild::getStudentId, studentId)
                .eq(SchoolInterestClassesChild::getInterestClassesId, id)
        ;
        List<SchoolInterestClassesChild> childList = childMapper.selectList(lqw);
        if (StringUtils.isNull(childList) || childList.size() == 0) {
            //学生未参加该兴趣班
            classInfoVO.setIsJoin(NOJOIN);
        } else {
            classInfoVO.setIsJoin(JOIN);
        }
        BeanUtils.copyProperties(classes, classInfoVO);
        return classInfoVO;
    }

    //家长端学生所参加的兴趣班列表
    @Override
    public List<ClassVO> queryStuClassesList(SchoolInterestClasses schoolInterestClasses) {
        //获取当前登录学生id
        Long studentId = userInfoUtil.getStudentId();
        //学生所选兴趣班
        List<Long> classIds = schoolInterestClassesMapper.getClassIds(studentId);
        return schoolInterestClassesMapper.queryStuClassesList(schoolInterestClasses, classIds);
    }
}
