package yangtz.cs.liu.campus.service.impl.examination;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.examination.SchoolArtExam;
import yangtz.cs.liu.campus.domain.examination.SchoolTestProject;
import yangtz.cs.liu.campus.mapper.examination.SchoolArtExamMapper;
import yangtz.cs.liu.campus.mapper.examination.SchoolTestProjectMapper;
import yangtz.cs.liu.campus.service.examination.ISchoolTestProjectService;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;


/**
 * 测试项目Service业务层处理
 *
 * @author wengxiulin
 * @date 2023-04-11
 */
@Service
public class SchoolTestProjectServiceImpl extends ServiceImpl<SchoolTestProjectMapper,SchoolTestProject> implements ISchoolTestProjectService
{
    @Autowired
    private SchoolTestProjectMapper schoolTestProjectMapper;

    @Autowired
    private SchoolArtExamMapper examMapper;

    /**
     * 查询测试项目列表
     *
     * @param schoolTestProject examination
     * @return examination
     */
    @Override
    public List<SchoolTestProject> selectSchoolTestProjectList(SchoolTestProject schoolTestProject)
    {
        return schoolTestProjectMapper.selectSchoolTestProjectList(schoolTestProject);
    }

    //获取本次考试所能选择的测试项目
    @Override
    public List<SchoolTestProject> getProjectList(Long examId,SchoolTestProject schoolTestProject) {
        SchoolArtExam exam = examMapper.selectById(examId);
        String ids = exam.getProjectIds();
        List<String> result = Arrays.asList(ids.split(","));
        List<Long> idList = new ArrayList<>();
        for(String s : result){
            Long l = Long.parseLong(s);
            idList.add(l);
        }
        LambdaQueryWrapper<SchoolTestProject> lqw = new LambdaQueryWrapper<>();
        lqw
                .in(SchoolTestProject::getId,idList)
                .like(isNotNull(schoolTestProject.getProject()),SchoolTestProject::getProject,schoolTestProject.getProject())
                .orderByAsc(SchoolTestProject::getSchoolOrder)
                .orderByDesc(SchoolTestProject::getCreateTime);
        return schoolTestProjectMapper.selectList(lqw);
    }
}
