package yangtz.cs.liu.campus.service.impl.examination;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.constant.ArtExamConstant;
import yangtz.cs.liu.campus.domain.examination.SchoolArtExam;
import yangtz.cs.liu.campus.domain.examination.SchoolArtRelation;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.mapper.examination.SchoolArtExamMapper;
import yangtz.cs.liu.campus.mapper.examination.SchoolArtRelationMapper;
import yangtz.cs.liu.campus.service.examination.ISchoolArtExamService;
import yangtz.cs.liu.webpage.vo.WebArtExamForStudentVo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;

/**
 * @author xuten
 */
@Service
public class SchoolArtExamServiceImpl extends ServiceImpl<SchoolArtExamMapper, SchoolArtExam> implements ISchoolArtExamService {
    @Autowired
    private SchoolArtExamMapper artExamMapper;

    @Autowired
    private SchoolArtRelationMapper relationMapper;

    /**
     * 考务管理-考试管理-列表
     */
    @Override
    public List<SchoolArtExam> queryList(SchoolArtExam exam) {
        LambdaQueryWrapper<SchoolArtExam> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotNull(exam.getExamName()),SchoolArtExam::getExamName,exam.getExamName())
                .eq(isNotNull(exam.getStatus()),SchoolArtExam::getStatus,exam.getStatus())
                .orderByDesc(SchoolArtExam::getCreateTime)
        ;
        return artExamMapper.selectList(lqw);
    }

    /**
     * 网页版-考试报名页面处理list
     * */
    @Override
    public List<WebArtExamForStudentVo> getArtExam(Long studentId) {
        //获取状态是报名状态的考试信息
        LambdaQueryWrapper<SchoolArtExam> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolArtExam::getStatus, ArtExamConstant.INFOCHECK)
                .orderByDesc(SchoolArtExam::getCreateTime)
        ;
        List<SchoolArtExam> examList = artExamMapper.selectList(lqw);
        //获取考生报考的考试信息列表
        LambdaQueryWrapper<SchoolArtRelation> relaLqw = new LambdaQueryWrapper<>();
        relaLqw
                .eq(SchoolArtRelation::getStudentId,studentId)
                .eq(SchoolArtRelation::getSubmit,ArtExamConstant.SUBMIT)
                .orderByDesc(SchoolArtRelation::getCreateTime)
        ;
        List<SchoolArtRelation> relations = relationMapper.selectList(relaLqw);
        if(StringUtils.isNotNull(relations) && relations.size() > 0){
            List<Long> idList = relations.stream().map(SchoolArtRelation::getExamId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper<SchoolArtExam> examLqw = new LambdaQueryWrapper<>();
            examLqw.in(SchoolArtExam::getId, idList);
            List<SchoolArtExam> exams = artExamMapper.selectList(examLqw);
            /*//去重
            examList.removeAll(exams);
            //合并list
            examList.addAll(exams);*/
            examList = Stream.of(examList, exams)
                    .flatMap(Collection::stream)
                    .distinct()
                    .collect(Collectors.toList());
        }
        List<WebArtExamForStudentVo> list = new ArrayList<>();
        for(SchoolArtExam exam : examList){
            WebArtExamForStudentVo vo = new WebArtExamForStudentVo();
            vo.setId(exam.getId());
            vo.setExamName(exam.getExamName());
            vo.setDeadline(exam.getDeadline());
            /**
             * 当前状态，，，分为未报名和已报名考生（其实也就第二个步骤显示的略有不同）
             * ①当前学生未报名该考试，查不到考试与学生关系，或者可以查到考试与学生关系，提交状态为未提交， 并且考试状态为报名阶段（信息审核）， 则此时当前状态为  报名 ，
             *      若考试状态为其他，则根据考试的状态显示考生可看到的对应的当前状态
             *      例如：考试状态为考场分配，，未报名考生显示报名；
             *      考试状态为成绩发布-未报名考生显示准考证打印；
             *      考试状态为结束-未报名考生显示成绩查询
             * ③用户已完成提交报名，可以查到考试与学生关系，提交状态为已提交，并且此时的考试状态为报名阶段（信息审核），查不到审核状态，  则此时当前状态为  待审核； 如果可以查到审核状态，则显示对应审核状态；
             *      若考试状态为其他，则根据考试的状态显示考生可看到的对应的当前状态
             *      考试状态为考场分配，考生显示审核状态；
             *      考试状态为成绩发布-考生显示准考证打印；
             *      考试状态为结束-考生显示成绩查询
             * */
            SchoolArtRelation relation = relationMapper.getRelationByIds(exam.getId(),studentId);
            if(StringUtils.isNull(relation)){
                //未报名，查询不到信息，且考试状态为报名阶段（信息审核）(显示报名)
                if(ArtExamConstant.INFOCHECK.equals(exam.getStatus())){
                    vo.setCurrentState(ArtExamConstant.WEBBM);
                } else if (ArtExamConstant.ADDRESS.equals(exam.getStatus())) {
                    //未报名，查询不到信息，且考试状态为考场分配(显示审核)
                    vo.setCurrentState(ArtExamConstant.WEBSH);
                } else if (ArtExamConstant.SCORE.equals(exam.getStatus())) {
                    //未报名，查询不到信息，且考试状态为成绩发布（显示打印准考证）
                    vo.setCurrentState(ArtExamConstant.WEBZKZDY);
                }else {
                    //未报名，查询不到信息，且考试状态为结束（显示成绩查询）
                    vo.setCurrentState(ArtExamConstant.WEBCJCX);
                }
            }else {
                //可以查到考生和考试的关系
                //提交状态为未提交，也就是为报名
                if(ArtExamConstant.NOSUBMIT.equals(relation.getSubmit())){
                    if(ArtExamConstant.INFOCHECK.equals(exam.getStatus())){
                        //考试处于审核阶段，网页考试状态(显示报名)
                        vo.setCurrentState(ArtExamConstant.WEBBM);
                    } else if (ArtExamConstant.ADDRESS.equals(exam.getStatus())) {
                        //未报名，查询不到信息，且考试状态为考场分配(显示审核)
                        vo.setCurrentState(ArtExamConstant.WEBSH);
                    } else if (ArtExamConstant.SCORE.equals(exam.getStatus())) {
                        //未报名，查询不到信息，且考试状态为成绩发布（显示打印准考证）
                        vo.setCurrentState(ArtExamConstant.WEBZKZDY);
                    }else {
                        //未报名，查询不到信息，且考试状态为结束（显示成绩查询）
                        vo.setCurrentState(ArtExamConstant.WEBCJCX);
                    }
                }else {
                    //已报名
                    if(ArtExamConstant.INFOCHECK.equals(exam.getStatus())){
                        //在信息审核阶段，显示审核结果
                        /** 审核状态（只存在教育局信息时该字段没有值，0=驳回，1=通过，2 =退回修改,3=待审核） */
                        /**
                         * 考试当前状态（0=报名，1=待审核，2=通过，3=驳回，4=信息修改，5=准考证打印，6=成绩查询，7=审核）
                         * */
                        switch (relation.getAuditStatus()){
                            case "0": vo.setCurrentState(ArtExamConstant.WEBBH); break;
                            case "1": vo.setCurrentState(ArtExamConstant.WEBTG); break;
                            case "2": vo.setCurrentState(ArtExamConstant.WEBXXXG); break;
                            case "3": vo.setCurrentState(ArtExamConstant.WEBDSH); break;
                        }
                    } else if (ArtExamConstant.ADDRESS.equals(exam.getStatus())) {
                        //且考试状态为考场分配,显示审核结果
                        switch (relation.getAuditStatus()){
                            case "0": vo.setCurrentState(ArtExamConstant.WEBBH); break;
                            case "1": vo.setCurrentState(ArtExamConstant.WEBTG); break;
                            case "2": vo.setCurrentState(ArtExamConstant.WEBXXXG); break;
                            case "3": vo.setCurrentState(ArtExamConstant.WEBDSH); break;
                        }
                    } else if (ArtExamConstant.SCORE.equals(exam.getStatus())) {
                        //考试状态为成绩发布 显示准考证打印
                        vo.setCurrentState(ArtExamConstant.WEBZKZDY);
                    }else {
                        //未报名，查询不到信息，且考试状态为结束 显示成绩查询
                        vo.setCurrentState(ArtExamConstant.WEBCJCX);
                    }

                }
            }
            list.add(vo);
        }
        return list;
    }
}
