package yangtz.cs.liu.campus.service.impl.epidemic;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.core.annotation.DeptFilter;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.system.mapper.SysUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.epidemic.EpidemicUser;
import yangtz.cs.liu.campus.domain.exam.ExamUser;
import yangtz.cs.liu.campus.mapper.epidemic.EpidemicUserMapper;
import yangtz.cs.liu.campus.mapper.exam.ExamUserMapper;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicUserService;
import yangtz.cs.liu.campus.service.exam.IExamUserService;
import yangtz.cs.liu.campus.vo.epidemic.EpidemicUserVo;
import yangtz.cs.liu.campus.vo.exam.ExamUserVo;

import java.util.ArrayList;
import java.util.List;


@Service
public class EpidemicUserServiceImpl extends ServiceImpl<EpidemicUserMapper, EpidemicUser> implements IEpidemicUserService {

    @Autowired
    private EpidemicUserMapper epidemicUserMapper;

    @Autowired
    private SysUserMapper sysUserMapper;

    /**
     * 查询活动范围列表（通过exam_id联系）
     *
     * @param epidemicUser
     * @return
     */
    @Override
    public List<EpidemicUserVo> queryList(EpidemicUserVo epidemicUser) {
        return epidemicUserMapper.select(epidemicUser);
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @Override
    public List<EpidemicUserVo> export(List<Integer> ids) {
        List<EpidemicUserVo> list = new ArrayList<>();
        for (Integer id : ids) {
            //查询列表
            EpidemicUserVo epidemicUserVo = epidemicUserMapper.exportById(id);
            list.add(epidemicUserVo);
        }
        return list;
    }

    @Override
    public List<Long> selectAllUserIdByEpidemicId(Long epidemicId) {
        return epidemicUserMapper.selectAllUserIdByExamId(epidemicId);
    }

    @Override
    @DeptFilter(deptAlias = "d")
    public List<EpidemicUserVo> selectAddList(EpidemicUserVo epidemicUser, List<Long> userIdList) {
        return epidemicUserMapper.selectAddList(userIdList, epidemicUser);
    }

    @Override
    public int addExamUsers(Long epidemicId, Long[] userIds) {
        //检查是否该范围下已经有这个学员了
        List<Long> userIdList = epidemicUserMapper.selectAllUserIdByExamId(epidemicId);
        List<EpidemicUser> epidemicUserList = new ArrayList<>();

        for (Long userId : userIds) {
            if (userIdList.contains(userId)) {
                throw new ServiceException("问卷范围内已经有该学员");
            }
            //通过用户id去查询dept_id,dept_name,user_name
            SysUser user = sysUserMapper.selectUserById(userId);
            try {
                EpidemicUser epidemicUser = new EpidemicUser();
                epidemicUser.setEpidemicId(epidemicId);
                epidemicUser.setUserId(userId);
                epidemicUser.setDeptId(user.getDeptId());
                epidemicUser.setDeptName(user.getDept().getDeptName());
                epidemicUser.setUserName(user.getUserName());
                epidemicUser.insert();
                epidemicUserList.add(epidemicUser);
            }catch (Exception e){
                throw new ServiceException("有用户信息不完整，无法添加");
            }

        }
        return epidemicUserMapper.insertEpidemicUsers(epidemicUserList);
    }
}
