package yangtz.cs.liu.campus.service.impl.educationStatistics;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.core.utils.HolidayDateUtil;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.domain.studentTurnover.StudentTurnover;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMapper;
import yangtz.cs.liu.campus.mapper.schoolgrade.SchoolGradeMapper;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentMapper;
import yangtz.cs.liu.campus.service.educationStatistics.IEducationStatisticsService;
import yangtz.cs.liu.campus.service.impl.studentTurnover.StudentTurnoverServiceImpl;
import yangtz.cs.liu.campus.vo.educationStatistics.StatisticsAgeVo;
import yangtz.cs.liu.campus.vo.educationStatistics.StatisticsClassVo;
import yangtz.cs.liu.campus.vo.educationStatistics.StatisticsGradeVo;
import yangtz.cs.liu.campus.vo.educationStatistics.StatisticsVariationVo;


import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service
public class EducationStatisticsServiceImpl implements IEducationStatisticsService {
    @Autowired
    private SchoolClassMapper classMapper;

    @Autowired
    private SchoolStudentMapper studentMapper;
    @Autowired
    private StudentTurnoverServiceImpl studentTurnoverServiceImpl;

    @Autowired
    private SchoolGradeMapper gradeMapper;

    //获取班级统计
    @Override
    public List<StatisticsClassVo> getClassNum(int schoolYear) {
        //返回结果集
        List<StatisticsClassVo> list = new ArrayList<>();

        LambdaQueryWrapper<SchoolClass> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolClass::getSchoolYear, schoolYear)
                .orderByAsc(SchoolClass::getGradeValue)
                .orderByAsc(SchoolClass::getClassValue);
        //获取所选学年所有班级
        List<SchoolClass> classes = classMapper.selectList(lqw);
        //判断当前学年是否有学年，如果没有，则返回空列表
        if (StringUtils.isNull(classes) || classes.size() == 0) {
            return new ArrayList<>();
        }

        //所选学年有班级
        for (SchoolClass c : classes) {
            StatisticsClassVo vo = new StatisticsClassVo();
            //将c对象中的只赋值给vo
            BeanUtils.copyProperties(c, vo);
            //将年级处理成高中X年级
            vo.setGradeName("高中" + c.getGradeName());
            int num = 0;
            int boyNum = 0;
            int girlNum = 0;
            int picNum = 0;
            int noPicNum = 0;
            LambdaQueryWrapper<SchoolStudent> ss = new LambdaQueryWrapper<>();
            ss.eq(SchoolStudent::getClassId, c.getId());
            List<SchoolStudent> students = studentMapper.selectList(ss);
            //本班级下有学生
            if (StringUtils.isNotNull(students) && students.size() > 0) {
                //班级总人数
                num = students.size();

                for (SchoolStudent student : students) {
                    if ("0".equals(student.getSex())) {
                        boyNum++;
                    }
                    if ("1".equals(student.getSex())) {
                        girlNum++;
                    }
                    if (StringUtils.isNotNull(student.getAvatar())) {
                        picNum++;
                    } else {
                        noPicNum++;
                    }
                }


            }
            vo.setNum(num);
            vo.setBoyNum(boyNum);
            vo.setGirlNum(girlNum);
            vo.setPicNum(picNum);
            vo.setNoPicNum(noPicNum);
            list.add(vo);
        }
        return list;
    }

    @Override
    public List<StatisticsGradeVo> getGradeNum(int schoolYear) {
        List<StatisticsGradeVo> list = new ArrayList<>();
        for (int i = 1; i <= 3; i++) {
            LambdaQueryWrapper<SchoolClass> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(SchoolClass::getSchoolYear, schoolYear)
                    .eq(SchoolClass::getGradeValue, i)
                    .orderByAsc(SchoolClass::getClassValue);
            List<SchoolClass> classes = classMapper.selectList(queryWrapper);
            int allNumber = 0;
            int boyNumber = 0;
            int girlNumber = 0;
            int size = classes.size();
            StatisticsGradeVo vo = new StatisticsGradeVo();
            vo.setGradeValue(i);
            switch (i) {
                case 1:
                    vo.setGradeName("高中一年级");
                    break;
                case 2:
                    vo.setGradeName("高中二年级");
                    break;
                case 3:
                    vo.setGradeName("高中三年级");
                    break;
            }

            vo.setClassNum(size);
            for (SchoolClass Class : classes) {

                LambdaQueryWrapper<SchoolStudent> queryWrap1 = new LambdaQueryWrapper<>();
                queryWrap1.eq(SchoolStudent::getClassId, Class.getId());
                List<SchoolStudent> schoolStudents = studentMapper.selectList(queryWrap1);
                for (SchoolStudent schoolStudent : schoolStudents) {
                    if ("0".equals(schoolStudent.getSex())) {
                        boyNumber++;
                    }
                    if ("1".equals(schoolStudent.getSex())) {
                        girlNumber++;
                    }
                }
            }
            vo.setBoyNum(boyNumber);
            vo.setGirlNum(girlNumber);
            vo.setAllNum(boyNumber + girlNumber);
            list.add(vo);
        }
        return list;
    }

    @Override
    public List<StatisticsVariationVo> getVariationNum(String data, String data1) {
        StatisticsVariationVo vo = new StatisticsVariationVo();
        List<StatisticsVariationVo> listResult = new ArrayList<>();
        Date date1 = DateUtils.parseDate(data1);
        Date date = DateUtils.parseDate(data);
        // WebDataBinder webDataBinder=new WebDataBinder(data);
        LambdaQueryWrapper<StudentTurnover> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.ge(StudentTurnover::getEndTime, date);
        lambdaQueryWrapper.le(StudentTurnover::getEndTime, date1);
        List<StudentTurnover> list = studentTurnoverServiceImpl.list(lambdaQueryWrapper);
        int into = 0;
        int intoBorrowing = 0;
        int out = 0;
        int OutBorrowing = 0;
        int Dropped = 0;
        for (StudentTurnover studentTurnover : list) {
            if ("0".equals(studentTurnover.getChangeType())) {
                into = into + 1;
            }
            if ("1".equals(studentTurnover.getChangeType())) {
                intoBorrowing = intoBorrowing + 1;
            }
            if ("2".equals(studentTurnover.getChangeType())) {
                out = out + 1;
            }
            if ("3".equals(studentTurnover.getChangeType())) {
                OutBorrowing = OutBorrowing + 1;
            }
            if ("4".equals(studentTurnover.getChangeType())) {
                Dropped = Dropped + 1;
            }
        }
        vo.setInto(into);
        vo.setIntoBorrowing(intoBorrowing);
        vo.setOut(out);
        vo.setOutBorrowing(OutBorrowing);
        vo.setDropped(Dropped);
        vo.setAll(into + intoBorrowing + out + OutBorrowing + Dropped);
        listResult.add(vo);
        return listResult;


    }

    //年龄统计
    @Override
    public List<StatisticsAgeVo> getAgeNum() {
        List<StatisticsAgeVo> list = new ArrayList<>();
        //获取当前学年
        int schoolYear = HolidayDateUtil.getSchoolYear();
        //int schoolYear = 2021;
        //统计每个级部的班级里的学生的年龄个数
        for (int i = 1; i < 4; i++) {
            StatisticsAgeVo vo = new StatisticsAgeVo();
            int num13 = 0;
            int num14 = 0;
            int num15 = 0;
            int num16 = 0;
            int num17 = 0;
            int num18 = 0;
            int num19 = 0;
            int num20 = 0;
            int num21 = 0;
            int num22 = 0;
            vo.setGradeValue(i);
            switch (i) {
                case 1:
                    vo.setGradeName("高中一年级");
                    break;
                case 2:
                    vo.setGradeName("高中二年级");
                    break;
                case 3:
                    vo.setGradeName("高中三年级");
            }
            //统计级部的班级数
            LambdaQueryWrapper<SchoolClass> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(SchoolClass::getSchoolYear, schoolYear)
                    .eq(SchoolClass::getGradeValue, i)
                    .orderByAsc(SchoolClass::getClassValue);
            List<SchoolClass> classes = classMapper.selectList(queryWrapper);

            for (SchoolClass c : classes) {
                LambdaQueryWrapper<SchoolStudent> stuLqw = new LambdaQueryWrapper<>();
                stuLqw.eq(SchoolStudent::getClassId, c.getId());
                List<SchoolStudent> schoolStudents = studentMapper.selectList(stuLqw);
                for (SchoolStudent schoolStudent : schoolStudents) {
                    //计算学生年龄
                    int age = getAge(schoolStudent.getBirthday());
                    switch (age) {
                        case 13:
                            num13++;
                            break;
                        case 14:
                            num14++;
                            break;
                        case 15:
                            num15++;
                            break;
                        case 16:
                            num16++;
                            break;
                        case 17:
                            num17++;
                            break;
                        case 18:
                            num18++;
                            break;
                        case 19:
                            num19++;
                            break;
                        case 20:
                            num20++;
                            break;
                        case 21:
                            num21++;
                            break;
                        case 22:
                            num22++;
                            break;
                    }
                }
            }
            vo.setNum13(num13);
            vo.setNum14(num14);
            vo.setNum15(num15);
            vo.setNum16(num16);
            vo.setNum17(num17);
            vo.setNum18(num18);
            vo.setNum19(num19);
            vo.setNum20(num20);
            vo.setNum21(num21);
            vo.setNum22(num22);
            list.add(vo);
        }

        //设置合计
        StatisticsAgeVo vo = new StatisticsAgeVo();
        vo.setGradeName("合计");
        vo.setNum13(list.get(0).getNum13()+list.get(1).getNum13()+list.get(2).getNum13());
        vo.setNum14(list.get(0).getNum14()+list.get(1).getNum14()+list.get(2).getNum14());
        vo.setNum15(list.get(0).getNum15()+list.get(1).getNum15()+list.get(2).getNum15());
        vo.setNum16(list.get(0).getNum16()+list.get(1).getNum16()+list.get(2).getNum16());
        vo.setNum17(list.get(0).getNum17()+list.get(1).getNum17()+list.get(2).getNum17());
        vo.setNum18(list.get(0).getNum18()+list.get(1).getNum18()+list.get(2).getNum18());
        vo.setNum19(list.get(0).getNum19()+list.get(1).getNum19()+list.get(2).getNum19());
        vo.setNum20(list.get(0).getNum20()+list.get(1).getNum20()+list.get(2).getNum20());
        vo.setNum21(list.get(0).getNum21()+list.get(1).getNum21()+list.get(2).getNum21());
        vo.setNum22(list.get(0).getNum22()+list.get(1).getNum22()+list.get(2).getNum22());
        list.add(vo);
        return list;
    }

    //计算年龄
    private int getAge(Date birth) {
        Calendar cal = Calendar.getInstance();
        int thisYear = cal.get(Calendar.YEAR);
        int thisMonth = cal.get(Calendar.MONTH);
        int dayOfMonth = cal.get(Calendar.DAY_OF_MONTH);

        cal.setTime(birth);
        int birthYear = cal.get(Calendar.YEAR);
        int birthMonth = cal.get(Calendar.MONTH);
        int birthdayOfMonth = cal.get(Calendar.DAY_OF_MONTH);

        int age = thisYear - birthYear;

        // 未足月
        if (thisMonth <= birthMonth) {
            // 当月
            if (thisMonth == birthMonth) {
                // 未足日
                if (dayOfMonth < birthdayOfMonth) {
                    age--;
                }
            } else {
                age--;
            }
        }
        return age;
    }
}
