package yangtz.cs.liu.campus.service.impl.assetsType;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.spring.SpringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import yangtz.cs.liu.campus.domain.assetsType.SchoolAssetsType;
import yangtz.cs.liu.campus.mapper.assetsType.SchoolAssetsTypeMapper;
import yangtz.cs.liu.campus.service.assetsType.ISchoolAssetsTypeService;
import yangtz.cs.liu.campus.vo.assetsType.SchoolAssetsTypeVo;
import yangtz.cs.liu.campus.vo.assetsType.TypeTree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class SchoolAssetsTypeServiceImpl extends ServiceImpl<SchoolAssetsTypeMapper, SchoolAssetsType> implements ISchoolAssetsTypeService {
    @Autowired
    private SchoolAssetsTypeMapper typeMapper;

    /**查询资产分类列表*/
    @Override
    public List<SchoolAssetsTypeVo> selectTypeList(SchoolAssetsType type) {
        return typeMapper.selectTypeList(type);
    }

    /**查询资产分类列表*/
    @Override
    public SchoolAssetsTypeVo getInfo(Long id) {
        return typeMapper.getInfo(id);
    }

    /**检查资产分类是否存在*/
    @Override
    public Boolean checkIsExist(SchoolAssetsType type) {
        Long id = StringUtils.isNull(type.getId()) ? -1L : type.getId();
        //编号不能重
        LambdaQueryWrapper<SchoolAssetsType> num = new LambdaQueryWrapper<>();
        num.eq(SchoolAssetsType::getTypeNum,type.getTypeNum());
        SchoolAssetsType typeNum = typeMapper.selectOne(num);
        //父目录下资产分类名称不能重
        LambdaQueryWrapper<SchoolAssetsType> name = new LambdaQueryWrapper<>();
        name.eq(SchoolAssetsType::getTypeName,type.getTypeName())
                .eq(SchoolAssetsType::getPid,type.getPid());
        SchoolAssetsType typeName = typeMapper.selectOne(name);

        //存在
        if (StringUtils.isNotNull(typeNum)  && typeNum.getId().longValue() != id.longValue())
        {
            return true;
        }
        if (StringUtils.isNotNull(typeName) && typeName.getId().longValue() != id.longValue())
        {
            return true;
        }
        return false;
    }

    /**修改*/
    @Override
    public int updateType(SchoolAssetsType type) {
        //获取新的父节点
        SchoolAssetsTypeVo newParentType = typeMapper.getInfo(type.getId());
        //获取未修改前的
        SchoolAssetsTypeVo oldType = typeMapper.getInfo(type.getId());
        if(StringUtils.isNotNull(newParentType) && StringUtils.isNotNull(oldType)){
            String newAncestors = newParentType.getAncestors() + "," + newParentType.getId();
            String oldAncestors = oldType.getAncestors();
            type.setAncestors(newAncestors);
            updateTypeChildren(type.getId(),newAncestors,oldAncestors);
        }
        type.update();
        return typeMapper.updateById(type);
    }

    /**是否存在资产分类子节点*/
    @Override
    public boolean hasChildById(Long id) {
        return typeMapper.hasChildById(id) > 0;
    }

    /**查询资产树结构信息*/
    @Override
    public List<TypeTree> selectTypeTreeList(SchoolAssetsType type) {
        List<SchoolAssetsTypeVo> types = SpringUtils.getAopProxy(this).selectTypeList(type);
        return buildTypeTreeSelect(types);
    }

    /**构建前端所需要下拉树结构*/
    public List<TypeTree> buildTypeTreeSelect(List<SchoolAssetsTypeVo> types){
        List<SchoolAssetsTypeVo> typeTree = buildTypeTree(types);
        return typeTree.stream().map(TypeTree::new).collect(Collectors.toList());
    }

    /**构建前端所需要树结构*/
    public List<SchoolAssetsTypeVo> buildTypeTree(List<SchoolAssetsTypeVo> types){
        List<SchoolAssetsTypeVo> returnList = new ArrayList<>();
        List<Long> tempList = new ArrayList<Long>();
        for(SchoolAssetsTypeVo vo : types){
            tempList.add(vo.getId());
        }
        for(SchoolAssetsTypeVo vo : types){
            // 如果是顶级节点, 遍历该父节点的所有子节点
            if(!tempList.contains(vo.getPid())){
                recursionFn(types,vo);
                returnList.add(vo);
            }
        }

        if(returnList.isEmpty()){
            returnList = types;
        }
        return returnList;
    }

    /**递归列表*/
    private void recursionFn(List<SchoolAssetsTypeVo> list,SchoolAssetsTypeVo vo){
        // 得到子节点列表
        List<SchoolAssetsTypeVo> childList = getChildList(list,vo);
        vo.setChildren(childList);
        for(SchoolAssetsTypeVo tChild : childList){
            if(hasChild(list,tChild)){
                recursionFn(list,tChild);
            }
        }
    }

    /**得到子节点列表*/
    private List<SchoolAssetsTypeVo> getChildList(List<SchoolAssetsTypeVo> list,SchoolAssetsTypeVo vo){
        List<SchoolAssetsTypeVo> sList = new ArrayList<>();
        Iterator<SchoolAssetsTypeVo> it = list.iterator();
        while (it.hasNext()){
            SchoolAssetsTypeVo n = (SchoolAssetsTypeVo) it.next();
            if(StringUtils.isNotNull(n.getPid()) && n.getPid().longValue() == vo.getId().longValue()){
                sList.add(n);
            }
        }
        return sList;
    }

    /**判断是否有子节点*/
    private boolean hasChild(List<SchoolAssetsTypeVo> list,SchoolAssetsTypeVo vo){
        return getChildList(list,vo).size() > 0;
    }

    /**
     * 修改子元素关系
     *
     * @param id 被修改的ID
     * @param newAncestors 新的父ID集合
     * @param oldAncestors 旧的父ID集合
     */
    public void updateTypeChildren(Long id, String newAncestors, String oldAncestors)
    {
        List<SchoolAssetsType> children = typeMapper.selectChildrenTypeById(id);
        for (SchoolAssetsType child : children)
        {
            child.setAncestors(child.getAncestors().replaceFirst(oldAncestors, newAncestors));
        }
        if (children.size() > 0)
        {
            typeMapper.updateTypeChildren(children);
        }
    }

}
