package yangtz.cs.liu.campus.service.impl.area;

import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.area.SchoolArea;
import yangtz.cs.liu.campus.domain.area.SchoolAreaApply;
import yangtz.cs.liu.campus.domain.area.SchoolAreaDetail;
import yangtz.cs.liu.campus.domain.device.SchoolDeviceClaim;
import yangtz.cs.liu.campus.domain.device.SchoolDeviceRecord;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.mapper.area.SchoolAreaApplyMapper;
import yangtz.cs.liu.campus.mapper.area.SchoolAreaDetailMapper;
import yangtz.cs.liu.campus.mapper.area.SchoolAreaMapper;
import yangtz.cs.liu.campus.mapper.schoolgrade.SchoolGradeMapper;
import yangtz.cs.liu.campus.service.area.ISchoolAreaDetailService;
import yangtz.cs.liu.campus.vo.area.AreaDetailVo;
import yangtz.cs.liu.campus.vo.area.ImportDetailVo;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;
import static yangtz.cs.liu.campus.constant.SexConstant.MAN;

/**
 * 场地详情信息Service业务层处理
 *
 * @author ruoyi
 * @date 2022-09-29
 */
@Service
public class SchoolAreaDetailServiceImpl extends ServiceImpl<SchoolAreaDetailMapper, SchoolAreaDetail> implements ISchoolAreaDetailService
{
    @Autowired
    private SchoolAreaDetailMapper schoolAreaDetailMapper;
    @Autowired
    private SchoolAreaApplyMapper schoolAreaApplyMapper;
    @Autowired
    private SchoolAreaMapper schoolAreaMapper;
    @Autowired
    private SchoolGradeMapper schoolGradeMapper;

    @Override
    public List<AreaDetailVo> queryList(SchoolAreaDetail  schoolAreaDetail) {
        List<AreaDetailVo> list = schoolAreaDetailMapper.queryList(schoolAreaDetail);
        return list;
    }

    @Override
    public void checkImport(List<ImportDetailVo> list,Long areaId) {
        //检验是否为空
        if (StringUtils.isNull(list) || list.size() == 0) {
            throw new ServiceException("导入数据不能为空");
        }
        // 准备记录日志数据
        int failureNum = 0;
        StringBuilder failureMsg = new StringBuilder();
        for (ImportDetailVo importDetailVo : list) {
            if (StringUtils.isEmpty(importDetailVo.getAreaNo())) {
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、房间号为空,请您重新输入! ");
            } else {
                LambdaQueryWrapper<SchoolAreaDetail> lqw = new LambdaQueryWrapper<>();
                lqw.eq(SchoolAreaDetail::getAreaId,areaId);
                List<SchoolAreaDetail> detailList = schoolAreaDetailMapper.selectList(lqw);
                for(SchoolAreaDetail detail : detailList){
                    if(importDetailVo.equals(detail.getAreaNo())){
                        failureNum++;
                        failureMsg.append("<br/>" + failureNum + "、房间号已存在,请您重新输入! ");
                    }
                }
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共 " + failureNum + " 条数据格式不正确，错误如下：");
            throw new ServiceException(failureMsg.toString());
        }
    }

    @Override
    public String importAreaDetailList(List<ImportDetailVo> list,Long areaId) {
        /*if (StringUtils.isNull(list) || list.size() == 0) {
        throw new ServiceException("导入信息数据不能为空！");
    }
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        for (AreaDetailVo areaDetailVo : list) {
            try {
                // 验证是否存在这个信息
                boolean isExistsFlag = false;
                long id = 0; // 如果存在，更新的话，获取ID
                String areaNo = areaDetailVo.getAreaNo();  //房间号
                List<Integer> ids = schoolAreaDetailMapper.selecthomeList(areaNo);  //通过房间号查询所有id
                if (ids.size() > 0) {
                    isExistsFlag = true;
                    id = ids.get(0);
                }
                String areaName = areaDetailVo.getAreaName();
                Long areaId = schoolAreaMapper.selectIdByName(areaName);
                Integer gradeValue = schoolAreaDetailMapper.selectGradeByName(areaDetailVo.getGradeName());
                Integer classValue = schoolAreaDetailMapper.selectClassByName(areaDetailVo.getClassName());
                Long gradeId = schoolAreaDetailMapper.getGradeId(gradeValue,classValue);
                SchoolAreaDetail schoolAreaDetail = new SchoolAreaDetail();
                schoolAreaDetail.setAreaId(areaId);
                schoolAreaDetail.setAreaNo(areaNo);
                schoolAreaDetail.setGradeValue(gradeValue);
                schoolAreaDetail.setClassValue(classValue);
                schoolAreaDetail.setGradeId(gradeId);
                schoolAreaDetail.setSnNum(areaDetailVo.getSnNum());
                if (!isExistsFlag) {    //不存在这条数据
                    List idList = schoolAreaDetailMapper.selectAreaNameList(areaName);
                    if(null == idList || idList.size() ==0){
                        successMsg.append("<br/>" +  "场地名称：    " + areaName + " 不存在请确认");
                    }else{
                        schoolAreaDetailMapper.insert(schoolAreaDetail);
                        successNum++;
                        successMsg.append("<br/>" + successNum + "、房间号 " + schoolAreaDetail.getAreaNo() + " 导入成功");
                    }
                } else if (isExistsFlag) {   //存在这条数据,则更新
                    schoolAreaDetail.setId(id);
                    schoolAreaDetailMapper.updateById(schoolAreaDetail);
                    successNum++;
                    successMsg.append("<br/>" + successNum + "、房间号 " + areaDetailVo.getAreaNo() + " 更新成功");
                } else {
                    failureNum++;
                    failureMsg.append("<br/>" + failureNum + "、房间号 " + areaDetailVo.getAreaNo() + " 已存在");
                }
            }
            catch (Exception e) {
                failureNum++;
                String msg = "<br/>" + failureNum + "、房间号 " + areaDetailVo.getAreaNo() + " 导入失败：";
                failureMsg.append(msg + e.getCause().getMessage());
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共 " + failureNum + " 条数据格式不正确，错误如下：");
            throw new ServiceException(failureMsg.toString());
        } else {
            successMsg.insert(0, "恭喜您，数据已导入成功！共 " + successNum + " 条，数据如下：");
        }
        return successMsg.toString();*/
        // 准备记录日志数据
        int successNum = 0;
        StringBuilder successMsg = new StringBuilder();
        // 遍历并逐个导入
        for (ImportDetailVo importDetailVo : list) {
            try {
                SchoolAreaDetail detail = new SchoolAreaDetail();
                detail.setAreaId(areaId);
                detail.setAreaNo(importDetailVo.getAreaNo());
                detail.insert();
                schoolAreaDetailMapper.insert(detail);
                successNum++;
                successMsg.append("<br/>" + successNum + "数据" + " 导入成功");
            } catch (Exception e) {
                throw new ServiceException("导入失败");
            }
        }
        successMsg.insert(0, "恭喜您，数据已导入成功！共有 " + successNum + " 条，数据如下：");
        return successMsg.toString();
    }

    @Override
    public Long getGradeId(Integer gradeValue, Integer classValue) {
        Long gradeId = schoolAreaDetailMapper.getGradeId(gradeValue,classValue);
        return gradeId;
    }

    @Override
    public AreaDetailVo queryById(Long id) {
        AreaDetailVo areaDetailVo = schoolAreaDetailMapper.queryById(id);
        return areaDetailVo;
    }

    @Override
    public int deleteByIds(List<Long> ids) {
        // areaApply 删除
        LambdaUpdateWrapper<SchoolAreaApply> applyWrapper = new LambdaUpdateWrapper<>();
        applyWrapper.in(SchoolAreaApply::getDetailId,ids);
        schoolAreaApplyMapper.delete(applyWrapper);
        // areaDetail 表删除
        return schoolAreaDetailMapper.deleteBatchIds(ids);
    }

    @Override
    public List<AreaDetailVo> selectExportList(List<Long> ids) {
        List<AreaDetailVo> list = new ArrayList<>();
        for(Long id : ids){
            AreaDetailVo areaDetailVo = schoolAreaDetailMapper.selectExportList(id);
            list.add(areaDetailVo);
        }
        return list;
    }

    @Override
    public List<AreaDetailVo> selectListByAreaId(Long areaId) {
        return schoolAreaDetailMapper.selectListByAreaId(areaId);
    }

    @Override
    public List<SchoolAreaDetail> queryByAreaId(Long id) {
        LambdaQueryWrapper<SchoolAreaDetail> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolAreaDetail::getAreaId,id);
        List<SchoolAreaDetail> list = schoolAreaDetailMapper.selectList(wrapper);
        return list;
    }

}
