package yangtz.cs.liu.campus.service.examination;

import com.baomidou.mybatisplus.extension.service.IService;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.examination.SchoolArtRelation;
import yangtz.cs.liu.campus.vo.examination.ArtExamAddressVo;
import yangtz.cs.liu.campus.vo.examination.ArtExamScoreVo;

import java.util.List;

public interface ISchoolArtRelationService extends IService<SchoolArtRelation> {

    //通过考试id和考生id获取关系
    SchoolArtRelation getRelationByIds(Long examId, Long studentId);

    /**
     * 考试管理-考场分配-列表
     * */
    List<ArtExamAddressVo> getAddressList(ArtExamAddressVo vo);

    ArtExamScoreVo getAddressInfo(Long id);

    /**
     * 考试管理-考试管理-列表
     * */
    List<ArtExamScoreVo> getScoreList(ArtExamScoreVo vo);

    /**
     * 校验导入的考场数据
     * */
    void checkImportAddress(List<ArtExamAddressVo> list);

    /**
     * 导入考场数据
     * */
    String importDataAddress(List<ArtExamAddressVo> list,Long examId);

    /**
     * 考试管理-考场分配-结束
     */
    int addressEnd(Long examId);

    /**
     * 校验导入的成绩数据
     * */
    void checkImportScore(List<ArtExamScoreVo> list);

    /**
     * 导入成绩数据
     * */
    String importDataScore(List<ArtExamScoreVo> list,Long examId);

    /**
     * 考试管理-成绩发布-结束
     */
    int scoreEnd(Long examId);

}
