package yangtz.cs.liu.campus.service.epidemic;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.epidemic.EpidemicUser;
import yangtz.cs.liu.campus.domain.exam.ExamUser;
import yangtz.cs.liu.campus.vo.epidemic.EpidemicUserVo;
import yangtz.cs.liu.campus.vo.exam.ExamUserVo;

import java.util.List;

public interface IEpidemicUserService extends IService<EpidemicUser> {

    /**
     * 查询范围（成员）列表
     *
     * @param epidemicUser
     * @return
     */
    List<EpidemicUserVo> queryList(EpidemicUserVo epidemicUser);

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    List<EpidemicUserVo> export(List<Integer> ids);

    List<Long> selectAllUserIdByEpidemicId(Long epidemicId);

    List<EpidemicUserVo> selectAddList(EpidemicUserVo epidemicUser, List<Long> userIdList);

    int addExamUsers(Long examId, Long[] userIds);
}
