package yangtz.cs.liu.campus.service.device;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.device.SchoolDeviceRecord;
import yangtz.cs.liu.campus.vo.device.RecordByIdVo;
import yangtz.cs.liu.campus.vo.device.RecordListVo;
import yangtz.cs.liu.campus.vo.device.RecordTodoVo;

/**
 * 设备维修Service接口
 *
 * @author ruoyi
 * @date 2022-10-16
 */
public interface ISchoolDeviceRecordService extends IService<SchoolDeviceRecord>
{
    List<RecordListVo> queryList(String submitState,RecordListVo recordListVo);

    List<RecordListVo> getByIds(List<Long> ids);

    RecordByIdVo getInfo(Long id);

    int submitApply(SchoolDeviceRecord schoolDeviceRecord, String userName, String instandhaltung, Map<String, Object> variables);

    List<RecordTodoVo> findTodoTasks(String instandhaltung, SchoolDeviceRecord entity, String userId);

    List<RecordTodoVo> findDoneTasks(String instandhaltung, SchoolDeviceRecord entity, String toString);

    List<RecordTodoVo> findMyTodoTasks(String instandhaltung, SchoolDeviceRecord entity, String userId);
}
