package yangtz.cs.liu.campus.service.assetsType;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.TreeSelect;
import com.ruoyi.common.core.domain.entity.SysDept;
import yangtz.cs.liu.campus.domain.area.SchoolArea;
import yangtz.cs.liu.campus.domain.assetsType.SchoolAssetsType;
import yangtz.cs.liu.campus.vo.assetsType.SchoolAssetsTypeVo;
import yangtz.cs.liu.campus.vo.assetsType.TypeTree;

import java.util.List;

public interface ISchoolAssetsTypeService extends IService<SchoolAssetsType> {
    /**查询资产分类列表*/
    public List<SchoolAssetsTypeVo> selectTypeList(SchoolAssetsType type);

    /**根据id查询单个*/
    public SchoolAssetsTypeVo getInfo(Long id);

    /**检查资产分类是否存在*/
    Boolean checkIsExist(SchoolAssetsType type);

    /**修改*/
    public int updateType(SchoolAssetsType type);

    /**是否存在资产分类子节点*/
    public boolean hasChildById(Long id);

    /**查询资产树结构信息*/
    public List<TypeTree> selectTypeTreeList(SchoolAssetsType type);
}
