package yangtz.cs.liu.campus.mapper.student;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.security.core.parameters.P;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.vo.student.SchoolStudentNameVO;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;
import yangtz.cs.liu.wechat.vo.userInfo.UserInfoVo;

import java.util.List;

@Mapper
public interface SchoolStudentMapper extends BaseMapper<SchoolStudent> {
    List<SchoolStudentVO> queryList(SchoolStudentVO schoolStudent);

    /**获取级部学生*/
    List<SchoolStudentVO> getGradeStudent(@Param("classIds") List<Long> classIds,
                                          @Param("entity")SchoolStudentVO schoolStudent);

    SchoolStudentVO getInfo(Long id);

    /*
    * 查看字段数据是否重复
    * */
    List<SchoolStudent> query(SchoolStudent schoolStudent);

    List<SchoolStudentNameVO> queryName(SchoolStudent schoolStudent);

    /**
     * 微信公众号登录查询（学生身份证）
     * @param studentIdCard
     * @return
     */
    SchoolStudent selectByIdCard(String studentIdCard);

    /**
     * 公众号老师查看具体带的学生
     * @param teacherId
     * @return
     */
    List<SchoolStudent> getMemberByTeacher(Long teacherId);

    /**
     * 家长查看班级其他同学
     * @param studentId
     * @return
     */
    List<SchoolStudent> getMemberByParent(Long studentId);


    /**
     * 公众号：教职工通过学生id查询学生基本信息
     *
     * @param studentId
     * @return
     */
    List<UserInfoVo> getStudentInfo(Long studentId);

    /**
     * 数据导入
     * @param schoolStudentVO
     * @return
     */
    int insertStudent(SchoolStudentVO schoolStudentVO);

    List<SchoolStudent> noSelect(@Param("studentIds") List<Long> studentIds, @Param("schoolStudent")SchoolStudent schoolStudent);

    /**
     * 家长端修改头像（学生头像）
     * @return 结果
     */
    public int updateStudentAvatar(@Param("id") Long id, @Param("avatar") String avatar);

    /**
     * 通过身份证号获取信息
     * @param idCard
     * @return
     */
    SchoolStudentVO getInfoByidCard(String idCard);
}
