package yangtz.cs.liu.campus.mapper.schoolgrade;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGradeMentor;
import yangtz.cs.liu.campus.vo.schoolgrade.SchoolGradeMentorVo;
import yangtz.cs.liu.wechat.vo.schoolGrade.SchoolGradeVo;

import java.util.List;

/**
 * 班级管理Mapper接口
 */
@Mapper
public interface SchoolGradeMapper extends BaseMapper<SchoolGrade> {
    List<Long> getGradeId(@Param("userId") Long userId,
                          @Param("schoolYear")int schoolYear);

    List<Long> getMemberGradeId(@Param("userId") Long userId,
                          @Param("schoolYear")int schoolYear);
    List<SchoolGrade> selectGrades(int gradeValue);

    List<Long> getGradeIdsByYear(int schoolYear);
}
