package yangtz.cs.liu.campus.mapper.schoolcalendar;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.bind.annotation.PathVariable;
import yangtz.cs.liu.campus.domain.schoolcalendar.SchoolCalendarDetail;
import yangtz.cs.liu.campus.vo.schoolcalendar.SchoolCalendarDetailVo;

import java.util.Date;
import java.util.List;

@Mapper
public interface SchoolCalendarDetailMapper extends BaseMapper<SchoolCalendarDetail> {
    public List<SchoolCalendarDetailVo> selectSchoolCalendarDetailList(SchoolCalendarDetail schoolCalendarDetail);

    public SchoolCalendarDetailVo getQueryOne(@Param("id") Long id);


    List<SchoolCalendarDetail> getCalendar(@Param("date") Date date,@Param("calendarId") Long calendarId);

    /**
     * 获取当前月份所有节假日
     * @param start
     * @param end
     * @return
     */
    List<SchoolCalendarDetail> getMonth(@Param("idList")List<Long> idList,
                                        @Param("start") Date start,
                                        @Param("end") Date end);

    //获取当天的所有事件
    List<SchoolCalendarDetail> getMonthDay(@Param("idList")List<Long> idList,
                                        @Param("dayDate") Date dayDate);

    //获取一年的所有正在运行的校历的事件
    List<SchoolCalendarDetail> getThing(@Param("start") Date start,
                                        @Param("end") Date end,
                                        @Param("status") String status);
}
