package yangtz.cs.liu.campus.mapper.schoolStudio;

import yangtz.cs.liu.campus.domain.schoolStudio.SchoolStudio;

import java.util.List;

/**
 * 录播室管理Mapper接口
 *
 * @author ruoyi
 * @date 2023-07-10
 */
public interface SchoolStudioMapper
{
    /**
     * 查询录播室管理
     *
     * @param id 录播室管理主键
     * @return 录播室管理
     */
    public SchoolStudio selectSchoolStudioById(Long id);

    /**
     * 查询录播室管理列表
     *
     * @param schoolStudio 录播室管理
     * @return 录播室管理集合
     */
    public List<SchoolStudio> selectSchoolStudioList(SchoolStudio schoolStudio);

    /**
     * 新增录播室管理
     *
     * @param schoolStudio 录播室管理
     * @return 结果
     */
    public int insertSchoolStudio(SchoolStudio schoolStudio);

    /**
     * 修改录播室管理
     *
     * @param schoolStudio 录播室管理
     * @return 结果
     */
    public int updateSchoolStudio(SchoolStudio schoolStudio);

    /**
     * 批量删除录播室管理
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolStudioByIds(Long[] ids);
}
