package yangtz.cs.liu.campus.mapper.schoolEquipment;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolEquipmentRepair;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolEquipmentRepairVo;

import java.util.List;
import java.util.Map;

public interface EquipmentRepairMapper extends BaseMapper<SchoolEquipmentRepair> {

  @Select("SELECT er.id,er.equipment_id,el.encode,el.equipment_name,el.model,el.date_of_production,el.place ,\n"
      + "el.classification_code,er.report_repair_time,er.report_repair_id,er.report_repair,er.problem,\n"
      + "er.repair_id,er.evaluate,er.repair_name,er.repair_phone,er.repair_time,er.repair_state,er.remark\n"
      + "FROM school_equipment_repair  er LEFT JOIN school_equipment_ledger  el ON er.equipment_id=el.id WHERE er.id=#{id} and er.del_flag=0")
  public SchoolEquipmentRepairVo getEquipmentById(@Param("id") Long id);

  @Select("SELECT er.id,er.equipment_id,el.encode,el.equipment_name,el.model,el.date_of_production,el.place ,\n"
      + "el.classification_code,er.report_repair_time,er.report_repair_id,er.report_repair,er.problem,\n"
      + "er.repair_id,er.evaluate,er.repair_name,er.repair_phone,er.repair_time,er.repair_state,er.remark\n"
      + "FROM school_equipment_repair  er LEFT JOIN school_equipment_ledger  el ON er.equipment_id=el.id WHERE er.report_repair_id=#{reportRepairid} and er.del_flag=0")
  public List<SchoolEquipmentRepairVo> getMaintenanceList(@Param("reportRepairid") Long reportRepairid);

  @Select("SELECT er.id,er.equipment_id,el.encode,el.equipment_name,el.model,el.date_of_production,el.place ,\n"
      + "el.classification_code,er.report_repair_time,er.report_repair_id,er.report_repair,er.problem,\n"
      + "er.repair_id,er.evaluate,er.repair_name,er.repair_phone,er.repair_time,er.repair_state,er.remark\n"
      + "FROM school_equipment_repair  er LEFT JOIN school_equipment_ledger  el ON er.equipment_id=el.id and er.del_flag=0 ")
  public List<SchoolEquipmentRepairVo> getlist();

  @Select("SELECT er.id,er.equipment_id,el.encode,el.equipment_name,el.model,el.date_of_production,el.place ,\n"
      + "el.classification_code,er.report_repair_time,er.report_repair_id,er.report_repair,er.problem,\n"
      + "er.repair_id,er.evaluate,er.repair_name,er.repair_phone,er.repair_time,er.repair_state,er.remark\n"
      + "FROM school_equipment_repair  er LEFT JOIN school_equipment_ledger  el ON er.equipment_id=el.id and er.del_flag=0")
  public List<SchoolEquipmentRepairVo> getMaintenanceUserList();

    /**
     * 查看设备报修列表
     * @param schoolEquipmentRepairVo
     * @return
     */
    List<SchoolEquipmentRepairVo> selectSchoolEquipmentRepairVoList(SchoolEquipmentRepairVo schoolEquipmentRepairVo);

    /**
     * 查看设备报修详细信息
     * @param id
     * @return
     */
    SchoolEquipmentRepairVo selectSchoolEquipmentRepairVoById(Long id);

    /**
     * 根据自编码获取设备信息
     * @param
     * @return
     */
    Map<String, String> getEquipment(@Param("encode") String encode);

    /**
     * 删除设备报修
     * @param ids
     * @return
     */
    int deleteSchoolEquipmentRepairById(Long[] ids);

    /**
     * 获取修理人下拉框
     * @return
     */
    List<Map<String, String>> getRepair();

}
