package yangtz.cs.liu.campus.mapper.schoolEquipment;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolCirculation;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolCirculationVo;

@Mapper
public interface CirculationMapper extends BaseMapper<SchoolCirculation> {
    /*
     * 查看设备借出归还列表
     * @param schoolCirculationVo
     * @return
     */
    List<SchoolCirculationVo> selectSchoolCirculationVoList(SchoolCirculationVo schoolCirculationVo);

    /**
     * 查看设备借出归还详细信息
     * @param id
     * @return
     */
    SchoolCirculationVo selectSchoolCirculationVoById(Long id);

    /**
     * 删除设备借出归还详细信息
     * @param ids
     * @return
     */
    int deleteSchoolCirculationByIds(Long[] ids);

  @Select("SELECT sc.id,el.model,el.encode,sc.borrow_by,sc.borrow_time,sc.return_state,sc.return_time,sc.deadline,sc.return_equipment_condition ,sc.remark FROM school_circulation sc LEFT JOIN school_equipment_ledger el  on el.id = sc.equipment_id\n"
      + "  LEFT JOIN  school_product_category pc on pc.classification_code = el.classification_code WHERE pc.admin_id=#{adminId} and sc.del_flag=0")
  List<SchoolCirculationVo> getReturningEquipmentByadminId(@Param("adminId") Long adminId);


  @Select(" SELECT el.encode,el.equipment_name,el.model,sc.borrow_time ,sc.borrow_by, sc.purpose,sc.deadline ,\n"
      + "sc.return_equipment_condition,sc.return_time,sc.remark  FROM school_circulation sc LEFT JOIN school_equipment_ledger el on sc.equipment_id = el.id\n"
      + "WHERE sc.id =#{id} and  and sc.del_flag=0 ")
  SchoolCirculationVo getSchoolCirculationVoById(@Param("id")Long id);
}
