package yangtz.cs.liu.campus.mapper.schoolDepartmentBudget;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import yangtz.cs.liu.campus.domain.schoolDepartmentBudget.SchoolDepartmentBudget;
import yangtz.cs.liu.campus.domain.schoolDepartmentBudget.SchoolDepartmentBudgetProjectmx;
import yangtz.cs.liu.campus.vo.schoolDepartmentBudget.SchoolDepartmentBudgetVo;

import java.util.List;

/**
 * 科室预算填报Mapper接口
 *
 * @author ruoyi
 * @date 2023-07-11
 */
public interface SchoolDepartmentBudgetMapper extends BaseMapper<SchoolDepartmentBudget>
{
    /**
     * 查询科室预算填报
     *
     * @param id 科室预算填报主键
     * @return 科室预算填报
     */
    public SchoolDepartmentBudgetVo selectSchoolDepartmentBudgetById(Long id);

    /**
     * 查询科室预算填报列表
     *
     * @param schoolDepartmentBudget 科室预算填报
     * @return 科室预算填报集合
     */
    public List<SchoolDepartmentBudgetVo> selectSchoolDepartmentBudgetList(SchoolDepartmentBudget schoolDepartmentBudget);

    /**
     * 新增科室预算填报
     *
     * @param schoolDepartmentBudget 科室预算填报
     * @return 结果
     */
    public int insertSchoolDepartmentBudget(SchoolDepartmentBudgetVo schoolDepartmentBudget);

    /**
     * 修改科室预算填报
     *
     * @param schoolDepartmentBudget 科室预算填报
     * @return 结果
     */
    public int updateSchoolDepartmentBudget(SchoolDepartmentBudgetVo schoolDepartmentBudget);

    /**
     * 删除科室预算填报
     *
     * @param id 科室预算填报主键
     * @return 结果
     */
    public int deleteSchoolDepartmentBudgetById(Long id);

    /**
     * 批量删除科室预算填报
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolDepartmentBudgetByIds(Long[] ids);

    /**
     * 批量删除科室预算填报项目明细
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolDepartmentBudgetProjectmxByDepartmentBudgetIds(Long[] ids);

    /**
     * 批量新增科室预算填报项目明细
     *
     * @param schoolDepartmentBudgetProjectmxList 科室预算填报项目明细列表
     * @return 结果
     */
    public int batchSchoolDepartmentBudgetProjectmx(List<SchoolDepartmentBudgetProjectmx> schoolDepartmentBudgetProjectmxList);


    /**
     * 通过科室预算填报主键删除科室预算填报项目明细信息
     *
     * @param id 科室预算填报ID
     * @return 结果
     */
    public int deleteSchoolDepartmentBudgetProjectmxByDepartmentBudgetId(Long id);
}
