package yangtz.cs.liu.campus.mapper.schoolDcwj;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.security.core.parameters.P;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwj;
import yangtz.cs.liu.campus.domain.schoolDuty.SchoolDuty;
import yangtz.cs.liu.campus.vo.schoolDcwj.DawjVo;
import yangtz.cs.liu.campus.vo.schoolDcwj.DcwjSenateVo;
import yangtz.cs.liu.wechat.vo.schoolDcwj.SchoolDcwjVo;
import yangtz.cs.liu.wechat.vo.schoolDcwj.Vo_SchoolDcwj;

import java.util.List;

/**
 * 调查问卷Mapper接口
 *
 * @author wengxiulin
 * @date 2023-02-27
 */
@Mapper
public interface SchoolDcwjMapper extends BaseMapper<SchoolDcwj> {

    /**
     * 查询调查问卷列表
     *
     * @param schoolDcwj 调查问卷
     * @return 调查问卷集合
     */
    public List<SchoolDcwj> selectSchoolDcwjList(SchoolDcwj schoolDcwj);

    //按级部过滤
    public List<DawjVo> queryList(@Param("idList") List<Long> idList,
                                  @Param("entity") SchoolDcwj schoolDcwj);

    /**
     * 修改调查问卷
     *
     * @param schoolDcwj 调查问卷
     * @return 结果
     */
    public int updateSchoolDcwj(SchoolDcwj schoolDcwj);

    /**
     * 删除调查问卷
     *
     * @param id 调查问卷主键
     * @return 结果
     */
    public int deleteSchoolDcwjById(Long id);

    /**
     * 批量删除调查问卷
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolDcwjByIds(Long[] ids);

    /**
     * wx获取问卷调查列表
     */
    List<Vo_SchoolDcwj> getDcwjList(@Param("studentId") Long studentId,@Param("state") String state);

    List<Vo_SchoolDcwj> teacherGetDcwjList(@Param("teacherId") Long teacherId,@Param("state") String state);

    /**
     * 教务管理-问卷调查-列表查看
     * */
    public List<DcwjSenateVo> senateList(@Param("entity")SchoolDcwj schoolDcwj);
}
