package yangtz.cs.liu.campus.mapper.schoolClass;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassMentor;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGradeMentor;
import yangtz.cs.liu.campus.vo.schoolClass.SchoolClassMentorVo;
import yangtz.cs.liu.campus.vo.schoolgrade.SchoolGradeMentorVo;

import java.util.List;

@Mapper
public interface SchoolClassMentorMapper extends BaseMapper<SchoolClassMentor> {

    List<SchoolClassMentorVo> selectSchoolClass(SchoolClassMentorVo schoolClassMentor);

    String selectByTeacherName(@Param("id") Long teacherId);

    SchoolClassMentorVo selectSchoolClassById(@Param("id") Long id);

    List<SchoolClassMentorVo> exportByIds(@Param("id") List<Integer> ids,@Param("classId") Long classId);

    //获取教工所教授的班级(只差当前班级是最新学年的)
    List<SchoolClassMentor> getMentorByTeacherId(@Param("teacherId") Long teacherId,
                                                 @Param("schoolYear") int schoolYear);

    List<SchoolClassMentor> getMentors(@Param("teacherId") Long teacherId,
                                                 @Param("schoolYear") int schoolYear);
}
