package yangtz.cs.liu.campus.mapper.schoolClass;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassEducational;

import java.util.List;


/**
 * 学校班级Mapper接口
 *
 * @author hxz
 * @date 2023-02-26
 */
@Mapper
public interface SchoolClassEducationalMapper  extends BaseMapper<SchoolClassEducational>
{
    /**
     * 查询学校班级
     *
     * @param id 学校班级主键
     * @return 学校班级
     */
    public SchoolClassEducational selectSchoolClassEducationalById(Long id);

    /**
     * 查询学校班级列表
     *
     * @param schoolClassEducational 学校班级
     * @return 学校班级集合
     */
    public List<SchoolClassEducational> selectSchoolClassEducationalList(SchoolClassEducational schoolClassEducational);

    /**
     * 新增学校班级
     *
     * @param schoolClassEducational 学校班级
     * @return 结果
     */
    public int insertSchoolClassEducational(SchoolClassEducational schoolClassEducational);

    /**
     * 修改学校班级
     *
     * @param schoolClassEducational 学校班级
     * @return 结果
     */
    public int updateSchoolClassEducational(SchoolClassEducational schoolClassEducational);

    /**
     * 删除学校班级
     *
     * @param id 学校班级主键
     * @return 结果
     */
    public int deleteSchoolClassEducationalById(Long id);

    /**
     * 批量删除学校班级
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSchoolClassEducationalByIds(Long[] ids);
}
