package yangtz.cs.liu.campus.mapper.patrol;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrol;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolDetails;
import yangtz.cs.liu.campus.vo.patrol.SchoolPatrolVo;
import yangtz.cs.liu.wechat.vo.patrol.PatrolVo;

import java.util.List;

/**
 * 课堂巡视Mapper接口
 */
@Mapper
public interface SchoolPatrolMapper extends BaseMapper<SchoolPatrol> {

    int rescore(Long patrolId);


    /**
     * 查询巡视列表
     *
     * @return
     */
    List<SchoolPatrolVo> queryList(@Param("entity") SchoolPatrolVo schoolPatrol);

    List<SchoolPatrolVo> exportByIds(List<Integer> ids);

    int updateScore(@Param("score") Long score, @Param("patrolId") Long patrolId);

    List<PatrolVo> getPatrolList(@Param("teacherId") Long teacherId,@Param("classId") Long classId);
}
